/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.traffic;

import com.alibaba.csp.sentinel.traffic.Instance;
import com.alibaba.csp.sentinel.traffic.InstanceListener;
import com.alibaba.csp.sentinel.traffic.InstanceManager;
import com.alibaba.csp.sentinel.traffic.LoadBalancer;
import com.alibaba.csp.sentinel.traffic.RouterFilter;
import com.alibaba.csp.sentinel.traffic.TrafficContext;
import com.alibaba.csp.sentinel.traffic.rule.router.TrafficRouterRuleManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClusterManager
implements InstanceListener {
    private List<RouterFilter> routerFilterList;
    private LoadBalancer loadBalancer;
    private InstanceManager instanceManager;
    private volatile Set<String> remoteAppName = Collections.emptySet();

    public ClusterManager(List<RouterFilter> routerFilterList, LoadBalancer loadBalancer, InstanceManager instanceManager) {
        this.routerFilterList = routerFilterList;
        this.loadBalancer = loadBalancer;
        this.instanceManager = instanceManager;
    }

    public Set<String> getRemoteAppName() {
        return this.remoteAppName;
    }

    public ClusterManager(List<RouterFilter> routerFilterList) {
        this.routerFilterList = routerFilterList;
    }

    public ClusterManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    public Instance selectOneInstance(TrafficContext context) {
        return this.loadBalancer.select(this.route(context), context);
    }

    public Instance loadBalance(TrafficContext context, List<Instance> instances) {
        return this.loadBalancer.select(instances, context);
    }

    public Instance loadBalance(TrafficContext context) {
        return this.loadBalancer.select(this.instanceManager.getInstances(), context);
    }

    public List<Instance> route(TrafficContext context) {
        List<Instance> instances = this.instanceManager.getInstances();
        for (RouterFilter routerFilter : this.routerFilterList) {
            instances = routerFilter.filter(instances, context);
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAppRule(List<Instance> instances) {
        HashSet<String> currentApplication = new HashSet<String>();
        if (instances != null && instances.size() > 0) {
            for (Instance instance : instances) {
                String applicationName = instance.getAppName();
                if (applicationName == null || applicationName.length() <= 0) continue;
                currentApplication.add(applicationName);
            }
        }
        if (!this.remoteAppName.equals(currentApplication)) {
            ClusterManager clusterManager = this;
            synchronized (clusterManager) {
                HashSet current = new HashSet(currentApplication);
                HashSet<String> previous = new HashSet<String>(this.remoteAppName);
                previous.removeAll(currentApplication);
                current.removeAll(this.remoteAppName);
                for (String app : current) {
                    TrafficRouterRuleManager.register(app);
                }
                for (String app : previous) {
                    TrafficRouterRuleManager.unregister(app);
                }
                this.remoteAppName = currentApplication;
            }
        }
    }

    @Override
    public void notify(List<Instance> instances) {
        this.registerAppRule(instances);
        this.instanceManager.storeInstances(instances);
    }
}

