/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block;

import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.util.function.Function;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class RuleManager<R> {
    private Map<String, List<R>> originalRules = new HashMap<String, List<R>>();
    private Map<Pattern, List<R>> regexRules = new HashMap<Pattern, List<R>>();
    private Map<String, List<R>> regexCacheRules = new HashMap<String, List<R>>();
    private Map<String, List<R>> simpleRules = new HashMap<String, List<R>>();
    private Function<List<R>, List<R>> generator = Function.identity();
    private final Predicate<R> predicate;

    public RuleManager() {
        this.predicate = r -> r instanceof AbstractRule && ((AbstractRule)r).isRegex();
    }

    public RuleManager(Function<List<R>, List<R>> generator, Predicate<R> predicate) {
        this.generator = generator;
        this.predicate = predicate;
    }

    public void updateRules(Map<String, List<R>> rulesMap) {
        this.originalRules = rulesMap;
        HashMap<Pattern, List<R>> regexRules = new HashMap<Pattern, List<R>>();
        HashMap<String, List<R>> simpleRules = new HashMap<String, List<R>>();
        for (Map.Entry<String, List<R>> entry : rulesMap.entrySet()) {
            String resource = entry.getKey();
            List<R> rules = entry.getValue();
            ArrayList<R> rulesOfSimple = new ArrayList<R>();
            ArrayList<R> rulesOfRegex = new ArrayList<R>();
            for (R rule : rules) {
                if (this.predicate.test(rule)) {
                    rulesOfRegex.add(rule);
                    continue;
                }
                rulesOfSimple.add(rule);
            }
            if (!rulesOfRegex.isEmpty()) {
                regexRules.put(Pattern.compile(resource), rulesOfRegex);
            }
            if (rulesOfSimple.isEmpty()) continue;
            simpleRules.put(resource, rulesOfSimple);
        }
        this.setRules(regexRules, simpleRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<R> getRules(String resource) {
        ArrayList<R> result = new ArrayList<R>(this.simpleRules.getOrDefault(resource, Collections.emptyList()));
        if (this.regexRules.isEmpty()) {
            return result;
        }
        if (this.regexCacheRules.containsKey(resource)) {
            result.addAll((Collection)this.regexCacheRules.get(resource));
            return result;
        }
        RuleManager ruleManager = this;
        synchronized (ruleManager) {
            if (this.regexCacheRules.containsKey(resource)) {
                result.addAll((Collection)this.regexCacheRules.get(resource));
                return result;
            }
            List<R> compilers = this.matcherFromRegexRules(resource);
            this.regexCacheRules.put(resource, compilers);
            result.addAll(compilers);
            return result;
        }
    }

    public List<R> getRules() {
        ArrayList rules = new ArrayList();
        for (Map.Entry<Pattern, List<R>> entry : this.regexRules.entrySet()) {
            rules.addAll(entry.getValue());
        }
        for (Map.Entry<Object, List<R>> entry : this.simpleRules.entrySet()) {
            rules.addAll(entry.getValue());
        }
        return rules;
    }

    public Map<String, List<R>> getOriginalRules() {
        return this.originalRules;
    }

    public boolean hasConfig(String resource) {
        if (resource == null) {
            return false;
        }
        return !this.getRules(resource).isEmpty();
    }

    public static boolean checkRegexResourceField(AbstractRule rule) {
        if (!rule.isRegex()) {
            return true;
        }
        String resourceName = rule.getResource();
        try {
            Pattern.compile(resourceName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private List<R> matcherFromRegexRules(String resource) {
        ArrayList compilers = new ArrayList();
        for (Map.Entry<Pattern, List<R>> entry : this.regexRules.entrySet()) {
            if (!entry.getKey().matcher(resource).matches()) continue;
            compilers.addAll(this.generator.apply(entry.getValue()));
        }
        return compilers;
    }

    private synchronized void setRules(Map<Pattern, List<R>> regexRules, Map<String, List<R>> simpleRules) {
        this.regexRules = regexRules;
        this.simpleRules = simpleRules;
        if (regexRules.isEmpty()) {
            this.regexCacheRules = Collections.emptyMap();
            return;
        }
        HashMap<String, List<R>> rebuildCacheRule = new HashMap<String, List<R>>(this.regexCacheRules.size());
        for (String resource : this.regexCacheRules.keySet()) {
            rebuildCacheRule.put(resource, this.matcherFromRegexRules(resource));
        }
        this.regexCacheRules = rebuildCacheRule;
    }
}

