/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec;

import com.alibaba.csp.sentinel.cluster.client.codec.registry.ResponseDataDecodeRegistry;
import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityDecoder;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;

public class DefaultResponseEntityDecoder
implements ResponseEntityDecoder<ByteBuf, ClusterResponse> {
    public ClusterResponse decode(ByteBuf source) {
        if (source.readableBytes() >= 6) {
            int xid = source.readInt();
            byte type = source.readByte();
            byte status = source.readByte();
            EntityDecoder<ByteBuf, Object> decoder = ResponseDataDecodeRegistry.getDecoder(type);
            if (decoder == null) {
                RecordLog.warn((String)"Unknown type of response data decoder: {}", (Object[])new Object[]{(int)type});
                return null;
            }
            Object data = source.readableBytes() == 0 ? null : decoder.decode((Object)source);
            return new ClusterResponse(xid, (int)type, (int)status, data);
        }
        return null;
    }
}

