/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.impl;

import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.StateMachine;
import com.alibaba.cola.statemachine.Transition;
import com.alibaba.cola.statemachine.Visitor;
import com.alibaba.cola.statemachine.builder.FailCallback;
import com.alibaba.cola.statemachine.impl.Debugger;
import com.alibaba.cola.statemachine.impl.PlantUMLVisitor;
import com.alibaba.cola.statemachine.impl.StateHelper;
import com.alibaba.cola.statemachine.impl.StateMachineException;
import com.alibaba.cola.statemachine.impl.SysOutVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StateMachineImpl<S, E, C>
implements StateMachine<S, E, C> {
    private String machineId;
    private final Map<S, State<S, E, C>> stateMap;
    private boolean ready;
    private FailCallback<S, E, C> failCallback;

    public StateMachineImpl(Map<S, State<S, E, C>> stateMap) {
        this.stateMap = stateMap;
    }

    @Override
    public boolean verify(S sourceStateId, E event) {
        this.isReady();
        State sourceState = this.getState(sourceStateId);
        List transitions = sourceState.getEventTransitions(event);
        return transitions != null && transitions.size() != 0;
    }

    @Override
    public S fireEvent(S sourceStateId, E event, C ctx) {
        this.isReady();
        Transition<S, E, C> transition = this.routeTransition(sourceStateId, event, ctx);
        if (transition == null) {
            Debugger.debug("There is no Transition for " + event);
            this.failCallback.onFail(sourceStateId, event, ctx);
            return sourceStateId;
        }
        return transition.transit(ctx, false).getId();
    }

    @Override
    public List<S> fireParallelEvent(S sourceState, E event, C context) {
        this.isReady();
        List<Transition<S, E, C>> transitions = this.routeTransitions(sourceState, event, context);
        ArrayList<S> result = new ArrayList<S>();
        if (transitions == null || transitions.isEmpty()) {
            Debugger.debug("There is no Transition for " + event);
            this.failCallback.onFail(sourceState, event, context);
            result.add(sourceState);
            return result;
        }
        for (Transition<S, E, C> transition : transitions) {
            S id = transition.transit(context, false).getId();
            result.add(id);
        }
        return result;
    }

    private Transition<S, E, C> routeTransition(S sourceStateId, E event, C ctx) {
        State sourceState = this.getState(sourceStateId);
        List transitions = sourceState.getEventTransitions(event);
        if (transitions == null || transitions.size() == 0) {
            return null;
        }
        Transition transit = null;
        for (Transition transition : transitions) {
            if (transition.getCondition() == null) {
                transit = transition;
                continue;
            }
            if (!transition.getCondition().isSatisfied(ctx)) continue;
            transit = transition;
            break;
        }
        return transit;
    }

    private List<Transition<S, E, C>> routeTransitions(S sourceStateId, E event, C context) {
        State sourceState = this.getState(sourceStateId);
        ArrayList result = new ArrayList();
        List transitions = sourceState.getEventTransitions(event);
        if (transitions == null || transitions.size() == 0) {
            return null;
        }
        for (Transition transition : transitions) {
            Transition transit = null;
            if (transition.getCondition() == null) {
                transit = transition;
            } else if (transition.getCondition().isSatisfied(context)) {
                transit = transition;
            }
            result.add(transit);
        }
        return result;
    }

    private State getState(S currentStateId) {
        State<S, E, C> state = StateHelper.getState(this.stateMap, currentStateId);
        if (state == null) {
            this.showStateMachine();
            throw new StateMachineException(currentStateId + " is not found, please check state machine");
        }
        return state;
    }

    private void isReady() {
        if (!this.ready) {
            throw new StateMachineException("State machine is not built yet, can not work");
        }
    }

    @Override
    public String accept(Visitor visitor) {
        StringBuilder sb = new StringBuilder();
        sb.append(visitor.visitOnEntry(this));
        for (State<S, E, C> state : this.stateMap.values()) {
            sb.append(state.accept(visitor));
        }
        sb.append(visitor.visitOnExit(this));
        return sb.toString();
    }

    @Override
    public void showStateMachine() {
        SysOutVisitor sysOutVisitor = new SysOutVisitor();
        this.accept(sysOutVisitor);
    }

    @Override
    public String generatePlantUML() {
        PlantUMLVisitor plantUMLVisitor = new PlantUMLVisitor();
        return this.accept(plantUMLVisitor);
    }

    @Override
    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public void setFailCallback(FailCallback<S, E, C> failCallback) {
        this.failCallback = failCallback;
    }
}

