/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.builder;

import com.alibaba.cola.statemachine.Action;
import com.alibaba.cola.statemachine.Condition;
import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.Transition;
import com.alibaba.cola.statemachine.builder.AbstractTransitionBuilder;
import com.alibaba.cola.statemachine.builder.ExternalTransitionBuilder;
import com.alibaba.cola.statemachine.builder.From;
import com.alibaba.cola.statemachine.builder.InternalTransitionBuilder;
import com.alibaba.cola.statemachine.builder.On;
import com.alibaba.cola.statemachine.builder.To;
import com.alibaba.cola.statemachine.builder.When;
import com.alibaba.cola.statemachine.impl.StateHelper;
import com.alibaba.cola.statemachine.impl.TransitionType;
import java.util.Map;

class TransitionBuilderImpl<S, E, C>
extends AbstractTransitionBuilder<S, E, C>
implements ExternalTransitionBuilder<S, E, C>,
InternalTransitionBuilder<S, E, C> {
    private State<S, E, C> source;
    private Transition<S, E, C> transition;

    public TransitionBuilderImpl(Map<S, State<S, E, C>> stateMap, TransitionType transitionType) {
        super(stateMap, transitionType);
    }

    @Override
    public From<S, E, C> from(S stateId) {
        this.source = StateHelper.getState(this.stateMap, stateId);
        return this;
    }

    @Override
    public To<S, E, C> within(S stateId) {
        this.target = StateHelper.getState(this.stateMap, stateId);
        this.source = this.target;
        return this;
    }

    @Override
    public When<S, E, C> when(Condition<C> condition) {
        this.transition.setCondition(condition);
        return this;
    }

    @Override
    public On<S, E, C> on(E event) {
        this.transition = this.source.addTransition(event, this.target, this.transitionType);
        return this;
    }

    @Override
    public void perform(Action<S, E, C> action) {
        this.transition.setAction(action);
    }
}

