/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.catchlog;

import com.alibaba.cola.dto.Response;
import com.alibaba.cola.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(ResponseHandler.class);

    public static Object handle(Class returnType, String errCode, String errMsg) {
        if (ResponseHandler.isColaResponse(returnType)) {
            return ResponseHandler.handleColaResponse(returnType, errCode, errMsg);
        }
        return null;
    }

    public static Object handle(Class returnType, BaseException e) {
        return ResponseHandler.handle(returnType, e.getErrCode(), e.getMessage());
    }

    private static Object handleColaResponse(Class returnType, String errCode, String errMsg) {
        try {
            Response response = (Response)returnType.newInstance();
            response.setSuccess(false);
            response.setErrCode(errCode);
            response.setErrMessage(errMsg);
            return response;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static boolean isColaResponse(Class returnType) {
        return returnType == Response.class || returnType.getGenericSuperclass() == Response.class;
    }
}

