/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.support;

import com.alibaba.cloud.stream.binder.rocketmq.support.RocketMQHeaderMapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.common.message.MessageConst;
import org.springframework.util.Assert;

public abstract class AbstractRocketMQHeaderMapper
implements RocketMQHeaderMapper {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private Charset charset;

    public AbstractRocketMQHeaderMapper() {
        this(DEFAULT_CHARSET);
    }

    public AbstractRocketMQHeaderMapper(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }

    protected boolean matches(String headerName) {
        return !MessageConst.STRING_HASH_SET.contains(headerName) && !"id".equals(headerName) && !"timestamp".equals(headerName) && !"contentType".equals(headerName) && !"replyChannel".equals(headerName) && !"errorChannel".equals(headerName);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }
}

