/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.AbstractHttpRequestMatcher;
import com.alibaba.cloud.dubbo.http.matcher.HeaderExpression;
import com.alibaba.cloud.dubbo.http.matcher.ProduceMediaTypeExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;

public class HttpRequestProducesMatcher
extends AbstractHttpRequestMatcher {
    private final List<ProduceMediaTypeExpression> expressions;

    public HttpRequestProducesMatcher(String ... produces) {
        this(produces, (String[])null);
    }

    public HttpRequestProducesMatcher(String[] produces, String[] headers) {
        this(HttpRequestProducesMatcher.parseExpressions(produces, headers));
    }

    private HttpRequestProducesMatcher(Collection<ProduceMediaTypeExpression> expressions) {
        this.expressions = new ArrayList<ProduceMediaTypeExpression>(expressions);
        Collections.sort(this.expressions);
    }

    private static Set<ProduceMediaTypeExpression> parseExpressions(String[] produces, String[] headers) {
        LinkedHashSet<ProduceMediaTypeExpression> result = new LinkedHashSet<ProduceMediaTypeExpression>();
        if (headers != null) {
            for (String header : headers) {
                HeaderExpression expr = new HeaderExpression(header);
                if (!"Accept".equalsIgnoreCase(expr.name) || expr.value == null) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)((String)expr.value))) {
                    result.add(new ProduceMediaTypeExpression(mediaType, expr.negated));
                }
            }
        }
        for (String produce : produces) {
            result.add(new ProduceMediaTypeExpression(produce));
        }
        return result;
    }

    @Override
    public boolean match(HttpRequest request) {
        if (this.expressions.isEmpty()) {
            return true;
        }
        HttpHeaders httpHeaders = request.getHeaders();
        List acceptedMediaTypes = httpHeaders.getAccept();
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (expression.match(acceptedMediaTypes)) continue;
            return false;
        }
        return true;
    }

    protected Collection<ProduceMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }
}

