/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.autoconfigure;

import com.alibaba.cloud.dubbo.autoconfigure.DubboMetadataAutoConfiguration;
import com.alibaba.cloud.dubbo.autoconfigure.condition.MissingSpringCloudRegistryConfigPropertyCondition;
import com.alibaba.cloud.dubbo.bootstrap.DubboBootstrapStartCommandLineRunner;
import com.alibaba.cloud.dubbo.bootstrap.DubboBootstrapWrapper;
import com.alibaba.cloud.dubbo.bootstrap.event.DubboBootstrapStartedEvent;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.DubboServiceRegistrationEventPublishingAspect;
import com.alibaba.cloud.dubbo.registry.SpringCloudRegistryFactory;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancePreDeregisteredEvent;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancePreRegisteredEvent;
import com.ecwid.consul.v1.agent.model.NewService;
import com.netflix.appinfo.InstanceInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.spring.ServiceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={DubboServiceRegistrationEventPublishingAspect.class, DubboBootstrapStartCommandLineRunner.class})
@ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration", "org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration", "org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration"}, value={DubboMetadataAutoConfiguration.class})
public class DubboServiceRegistrationAutoConfiguration {
    public static final String EUREKA_CLIENT_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration";
    public static final String CONSUL_AUTO_SERVICE_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration";
    public static final String CONSUL_AUTO_SERVICE_AUTO_REGISTRATION_CLASS_NAME = "org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration";
    public static final String ZOOKEEPER_AUTO_SERVICE_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.zookeeper.serviceregistry.ZookeeperAutoServiceRegistrationAutoConfiguration";
    private static final Logger logger = LoggerFactory.getLogger(DubboServiceRegistrationAutoConfiguration.class);
    @Autowired
    private DubboServiceMetadataRepository dubboServiceMetadataRepository;
    private Map<ServiceRegistry<Registration>, Set<Registration>> registrations = new ConcurrentHashMap<ServiceRegistry<Registration>, Set<Registration>>();

    @Bean
    @Conditional(value={MissingSpringCloudRegistryConfigPropertyCondition.class})
    public RegistryConfig defaultSpringCloudRegistryConfig() {
        return new RegistryConfig(SpringCloudRegistryFactory.ADDRESS, SpringCloudRegistryFactory.PROTOCOL);
    }

    @EventListener(value={DubboBootstrapStartedEvent.class})
    public void onDubboBootstrapStarted(DubboBootstrapStartedEvent event) {
        if (!event.getSource().isReady()) {
            return;
        }
        this.registrations.forEach((registry, registrations) -> registrations.forEach(registration -> {
            this.attachDubboMetadataServiceMetadata((Registration)registration);
            registry.register(registration);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={ServiceInstancePreRegisteredEvent.class})
    public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
        Registration registration = event.getSource();
        if (!DubboBootstrap.getInstance().isReady() || !DubboBootstrap.getInstance().isStarted()) {
            ServiceRegistry<Registration> registry;
            ServiceRegistry<Registration> serviceRegistry = registry = event.getRegistry();
            synchronized (serviceRegistry) {
                this.registrations.putIfAbsent(registry, new HashSet());
                this.registrations.get(registry).add(registration);
            }
        } else {
            this.attachDubboMetadataServiceMetadata(registration);
        }
    }

    @EventListener(value={ServiceInstancePreDeregisteredEvent.class})
    public void onServiceInstancePreDeregistered(ServiceInstancePreDeregisteredEvent event) {
        ServiceRegistry<Registration> registry = event.getRegistry();
        this.registrations.remove(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachDubboMetadataServiceMetadata(Registration registration) {
        if (registration == null) {
            return;
        }
        Registration registration2 = registration;
        synchronized (registration2) {
            Map metadata = registration.getMetadata();
            this.attachDubboMetadataServiceMetadata(metadata);
        }
    }

    private void attachDubboMetadataServiceMetadata(Map<String, String> metadata) {
        Map<String, String> serviceMetadata = this.dubboServiceMetadataRepository.getDubboMetadataServiceMetadata();
        if (!ObjectUtils.isEmpty(serviceMetadata)) {
            metadata.putAll(serviceMetadata);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration"})
    @AutoConfigureOrder
    class ConsulConfiguration {
        @Autowired
        private ConsulDiscoveryProperties consulDiscoveryProperties;

        ConsulConfiguration() {
        }

        @EventListener(value={DubboBootstrapStartedEvent.class})
        public void attachURLsIntoMetadataBeforeReRegist(DubboBootstrapStartedEvent event) {
            if (!event.getSource().isReady()) {
                return;
            }
            DubboServiceRegistrationAutoConfiguration.this.registrations.entrySet().removeIf(entry -> {
                Set registrations = (Set)entry.getValue();
                registrations.removeIf(registration -> {
                    Class registrationClass = AopUtils.getTargetClass((Object)registration);
                    String registrationClassName = registrationClass.getName();
                    return !DubboServiceRegistrationAutoConfiguration.CONSUL_AUTO_SERVICE_AUTO_REGISTRATION_CLASS_NAME.equalsIgnoreCase(registrationClassName);
                });
                return registrations.isEmpty();
            });
            DubboServiceRegistrationAutoConfiguration.this.registrations.forEach((registry, registrations) -> registrations.forEach(registration -> {
                ConsulRegistration consulRegistration = (ConsulRegistration)registration;
                this.attachURLsIntoMetadata(consulRegistration);
            }));
        }

        @EventListener(value={ServiceInstancePreRegisteredEvent.class})
        public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
            Registration registration = event.getSource();
            this.attachURLsIntoMetadata((ConsulRegistration)registration);
        }

        private void attachURLsIntoMetadata(ConsulRegistration consulRegistration) {
            Map<String, String> serviceMetadata = DubboServiceRegistrationAutoConfiguration.this.dubboServiceMetadataRepository.getDubboMetadataServiceMetadata();
            if (ObjectUtils.isEmpty(serviceMetadata)) {
                return;
            }
            NewService newService = consulRegistration.getService();
            for (Map.Entry<String, String> entry : serviceMetadata.entrySet()) {
                this.attAsTag(newService.getTags(), entry.getKey(), entry.getValue());
            }
        }

        private void attAsTag(List<String> tags, String key, String value) {
            Iterator<String> iter = tags.iterator();
            while (iter.hasNext()) {
                String tag = iter.next();
                String[] tmp = tag.split("=");
                if (!StringUtils.pathEquals((String)tmp[0], (String)key)) continue;
                iter.remove();
            }
            tags.add(key + "=" + value);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration"})
    class EurekaConfiguration
    implements SmartInitializingSingleton {
        @Autowired
        private ObjectProvider<Collection<ServiceBean>> serviceBeans;

        EurekaConfiguration() {
        }

        @EventListener(value={DubboBootstrapStartedEvent.class})
        public void onDubboBootstrapStarted(DubboBootstrapStartedEvent event) {
            DubboBootstrapWrapper wrapper = event.getSource();
            if (!wrapper.isReady()) {
                return;
            }
            DubboServiceRegistrationAutoConfiguration.this.registrations.forEach((registry, registrations) -> registrations.removeIf(registration -> {
                if (!(registration instanceof EurekaRegistration)) {
                    return false;
                }
                EurekaRegistration eurekaRegistration = (EurekaRegistration)registration;
                InstanceInfo instanceInfo = eurekaRegistration.getApplicationInfoManager().getInfo();
                EurekaInstanceConfigBean config = (EurekaInstanceConfigBean)eurekaRegistration.getInstanceConfig();
                config.setInitialStatus(InstanceInfo.InstanceStatus.UP);
                DubboServiceRegistrationAutoConfiguration.this.attachDubboMetadataServiceMetadata(instanceInfo.getMetadata());
                eurekaRegistration.getApplicationInfoManager().registerAppMetadata(instanceInfo.getMetadata());
                eurekaRegistration.getApplicationInfoManager().setInstanceStatus(InstanceInfo.InstanceStatus.UP);
                return true;
            }));
        }

        @EventListener(value={ServiceInstancePreRegisteredEvent.class})
        public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
            Registration registration = event.getSource();
            if (!(registration instanceof EurekaRegistration)) {
                return;
            }
            if (DubboBootstrap.getInstance().isReady() && DubboBootstrap.getInstance().isStarted()) {
                EurekaRegistration eurekaRegistration = (EurekaRegistration)registration;
                InstanceInfo instanceInfo = eurekaRegistration.getApplicationInfoManager().getInfo();
                EurekaInstanceConfigBean config = (EurekaInstanceConfigBean)eurekaRegistration.getInstanceConfig();
                config.setInitialStatus(InstanceInfo.InstanceStatus.UP);
                DubboServiceRegistrationAutoConfiguration.this.attachDubboMetadataServiceMetadata(instanceInfo.getMetadata());
                eurekaRegistration.getApplicationInfoManager().registerAppMetadata(instanceInfo.getMetadata());
            } else {
                EurekaRegistration eurekaRegistration = (EurekaRegistration)registration;
                EurekaInstanceConfigBean config = (EurekaInstanceConfigBean)eurekaRegistration.getInstanceConfig();
                config.setInitialStatus(InstanceInfo.InstanceStatus.STARTING);
            }
        }

        public void afterSingletonsInstantiated() {
            Collection serviceBeans = (Collection)this.serviceBeans.getIfAvailable();
            if (!ObjectUtils.isEmpty((Object)serviceBeans)) {
                serviceBeans.forEach(ServiceConfig::export);
            }
        }
    }
}

