/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.autoconfigure;

import com.alibaba.cloud.dubbo.autoconfigure.DubboServiceRegistrationAutoConfiguration;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancesChangedEvent;
import com.alibaba.cloud.dubbo.registry.event.SubscribedServicesChangedEvent;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.netflix.discovery.shared.Applications;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceWatch;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.springframework.cloud.client.discovery.DiscoveryClient"})
@ConditionalOnProperty(name={"spring.cloud.discovery.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration", "org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryAutoConfiguration", "org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration", "com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration"}, value={DubboServiceRegistrationAutoConfiguration.class})
public class DubboServiceDiscoveryAutoConfiguration {
    public static final String ZOOKEEPER_DISCOVERY_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryAutoConfiguration";
    public static final String CONSUL_DISCOVERY_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration";
    public static final String NACOS_DISCOVERY_AUTO_CONFIGURATION_CLASS_NAME = "com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration";
    private final DubboServiceMetadataRepository dubboServiceMetadataRepository;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ApplicationEventPublisher applicationEventPublisher;
    private final DiscoveryClient discoveryClient;
    private final AtomicReference<Object> heartbeatState = new AtomicReference();
    private final ObjectProvider<Predicate<HeartbeatEvent>> heartbeatEventChangedPredicate;
    @Value(value="${spring.application.name:${dubbo.application.name:application}}")
    private String currentApplicationName;

    public DubboServiceDiscoveryAutoConfiguration(DubboServiceMetadataRepository dubboServiceMetadataRepository, ApplicationEventPublisher applicationEventPublisher, DiscoveryClient discoveryClient, ObjectProvider<Predicate<HeartbeatEvent>> heartbeatEventChangedPredicate) {
        this.dubboServiceMetadataRepository = dubboServiceMetadataRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.discoveryClient = discoveryClient;
        this.heartbeatEventChangedPredicate = heartbeatEventChangedPredicate;
    }

    private void dispatchServiceInstancesChangedEvent(String serviceName, List<ServiceInstance> serviceInstances) {
        if (!StringUtils.hasText((String)serviceName) || Objects.equals(this.currentApplicationName, serviceName) || serviceInstances == null) {
            return;
        }
        ServiceInstancesChangedEvent event = new ServiceInstancesChangedEvent(serviceName, serviceInstances);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The event of the service instances[name : {} , size : {}] change is about to be dispatched", (Object)serviceName, (Object)serviceInstances.size());
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }

    private List<ServiceInstance> getInstances(String serviceName) {
        return this.discoveryClient.getInstances(serviceName);
    }

    @EventListener(value={HeartbeatEvent.class})
    public void onHeartbeatEvent(HeartbeatEvent event) {
        Stream<String> subscribedServices = this.dubboServiceMetadataRepository.initSubscribedServices();
        this.heartbeatEventChangedPredicate.ifAvailable(predicate -> {
            if (predicate.test(event)) {
                subscribedServices.forEach(serviceName -> {
                    List<ServiceInstance> serviceInstances = this.getInstances((String)serviceName);
                    this.dispatchServiceInstancesChangedEvent((String)serviceName, serviceInstances);
                });
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public Predicate<HeartbeatEvent> defaultHeartbeatEventChangePredicate() {
        return event -> {
            Object newState;
            Object oldState = this.heartbeatState.get();
            return this.heartbeatState.compareAndSet(oldState, newState = event.getValue()) && !Objects.equals(oldState, newState);
        };
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration"})
    class NacosConfiguration {
        private final NamingService namingService;
        private final NacosDiscoveryProperties nacosDiscoveryProperties;
        private final Set<String> listeningServices;

        NacosConfiguration(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
            this.namingService = nacosServiceManager.getNamingService(nacosDiscoveryProperties.getNacosProperties());
            this.nacosDiscoveryProperties = nacosDiscoveryProperties;
            this.listeningServices = new ConcurrentSkipListSet<String>();
        }

        @Bean
        public Predicate<HeartbeatEvent> heartbeatEventChangedPredicate() {
            return event -> false;
        }

        @EventListener(value={SubscribedServicesChangedEvent.class})
        public void onSubscribedServicesChangedEvent(SubscribedServicesChangedEvent event) throws Exception {
            event.getNewSubscribedServices().forEach(this::subscribeEventListener);
        }

        private void subscribeEventListener(String serviceName) {
            if (this.listeningServices.add(serviceName)) {
                try {
                    String group = this.nacosDiscoveryProperties.getGroup();
                    this.namingService.subscribe(serviceName, group, event -> {
                        if (event instanceof NamingEvent) {
                            NamingEvent namingEvent = (NamingEvent)event;
                            List serviceInstances = NacosServiceDiscovery.hostToServiceInstanceList((List)namingEvent.getInstances(), (String)serviceName);
                            DubboServiceDiscoveryAutoConfiguration.this.dispatchServiceInstancesChangedEvent(serviceName, serviceInstances);
                        }
                    });
                }
                catch (NacosException e) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration"})
    class ConsulConfiguration {
        ConsulConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryAutoConfiguration"})
    @Aspect
    public class ZookeeperConfiguration
    implements ApplicationListener<InstanceRegisteredEvent> {
        public static final String CHILD_EVENT_POINTCUT_EXPRESSION = "execution(void org.springframework.cloud.zookeeper.discovery.ZookeeperServiceWatch.childEvent(..)) && args(client,event)";
        public static final String NODE_PATH_SEPARATOR = "/";
        private static final String SERVICE_NAME_PATH_VARIABLE_NAME = "serviceName";
        private static final String SERVICE_INSTANCE_ID_PATH_VARIABLE_NAME = "serviceInstanceId";
        private final ZookeeperServiceWatch zookeeperServiceWatch;
        private final String rootPath;
        private final AntPathMatcher pathMatcher;
        private final String serviceInstancePathPattern;
        private final ThreadLocal<String> processedServiceNameThreadLocal;

        ZookeeperConfiguration(ZookeeperDiscoveryProperties zookeeperDiscoveryProperties, ZookeeperServiceWatch zookeeperServiceWatch) {
            this.zookeeperServiceWatch = zookeeperServiceWatch;
            this.rootPath = zookeeperDiscoveryProperties.getRoot();
            this.pathMatcher = new AntPathMatcher(NODE_PATH_SEPARATOR);
            this.serviceInstancePathPattern = this.rootPath + NODE_PATH_SEPARATOR + "{" + SERVICE_NAME_PATH_VARIABLE_NAME + "}" + NODE_PATH_SEPARATOR + "{" + SERVICE_INSTANCE_ID_PATH_VARIABLE_NAME + "}";
            this.processedServiceNameThreadLocal = new ThreadLocal();
        }

        @Bean
        public Predicate<HeartbeatEvent> heartbeatEventChangedPredicate() {
            return event -> false;
        }

        public void onApplicationEvent(InstanceRegisteredEvent event) {
            this.reattachTreeCacheListeners();
        }

        private void reattachTreeCacheListeners() {
            TreeCache treeCache = this.zookeeperServiceWatch.getCache();
            Listenable listenable = treeCache.getListenable();
            LinkedList otherListeners = new LinkedList();
            if (listenable instanceof ListenerContainer) {
                ListenerContainer listenerContainer = (ListenerContainer)listenable;
                listenerContainer.forEach(listener -> {
                    if (!(listener instanceof ZookeeperServiceWatch)) {
                        otherListeners.add(listener);
                    }
                    return null;
                });
                listenerContainer.clear();
                listenerContainer.addListener((Object)this.zookeeperServiceWatch);
                otherListeners.forEach(arg_0 -> ((ListenerContainer)listenerContainer).addListener(arg_0));
            } else if (DubboServiceDiscoveryAutoConfiguration.this.logger.isWarnEnabled()) {
                DubboServiceDiscoveryAutoConfiguration.this.logger.warn("Tell me which version Curator framework current application used? I will do better :D");
            }
        }

        @Before(value="execution(void org.springframework.cloud.zookeeper.discovery.ZookeeperServiceWatch.childEvent(..)) && args(client,event)")
        public void beforeChildEvent(CuratorFramework client, TreeCacheEvent event) {
            String serviceName;
            if (this.supportsEventType(event) && StringUtils.hasText((String)(serviceName = this.resolveServiceName(event)))) {
                DubboServiceDiscoveryAutoConfiguration.this.dispatchServiceInstancesChangedEvent(serviceName, DubboServiceDiscoveryAutoConfiguration.this.getInstances(serviceName));
            }
        }

        @After(value="execution(void org.springframework.cloud.zookeeper.discovery.ZookeeperServiceWatch.childEvent(..)) && args(client,event)")
        public void afterChildEvent(CuratorFramework client, TreeCacheEvent event) {
        }

        private String resolveServiceName(TreeCacheEvent event) {
            ChildData childData = event.getData();
            String path = childData.getPath();
            if (DubboServiceDiscoveryAutoConfiguration.this.logger.isDebugEnabled()) {
                DubboServiceDiscoveryAutoConfiguration.this.logger.debug("ZK node[path : {}] event type : {}", (Object)path, (Object)event.getType());
            }
            String serviceName = null;
            if (this.pathMatcher.match(this.serviceInstancePathPattern, path)) {
                Map variables = this.pathMatcher.extractUriTemplateVariables(this.serviceInstancePathPattern, path);
                serviceName = (String)variables.get(SERVICE_NAME_PATH_VARIABLE_NAME);
            }
            return serviceName;
        }

        private boolean supportsEventType(TreeCacheEvent event) {
            TreeCacheEvent.Type eventType = event.getType();
            return eventType.equals((Object)TreeCacheEvent.Type.NODE_ADDED) || eventType.equals((Object)TreeCacheEvent.Type.NODE_REMOVED) || eventType.equals((Object)TreeCacheEvent.Type.NODE_UPDATED);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration"})
    public class EurekaConfiguration {
        private final AtomicReference<String> appsHashCodeCache = new AtomicReference();

        @Bean
        public Predicate<HeartbeatEvent> heartbeatEventChangedPredicate() {
            return event -> {
                CloudEurekaClient cloudEurekaClient;
                Applications applications;
                String appsHashCode;
                String oldAppsHashCode = this.appsHashCodeCache.get();
                return this.appsHashCodeCache.compareAndSet(oldAppsHashCode, appsHashCode = (applications = (cloudEurekaClient = (CloudEurekaClient)event.getSource()).getApplications()).getAppsHashCode()) && !Objects.equals(oldAppsHashCode, appsHashCode);
            };
        }
    }
}

