/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.custom;

import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.cloud.sentinel.datasource.config.AbstractDataSourceProperties;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SentinelDataSourceHandler
implements SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(SentinelDataSourceHandler.class);
    private final List<String> dataTypeList = Arrays.asList("json", "xml");
    private final String DATA_TYPE_FIELD = "dataType";
    private final String CUSTOM_DATA_TYPE = "custom";
    private final String CONVERTER_CLASS_FIELD = "converterClass";
    private final DefaultListableBeanFactory beanFactory;
    private final SentinelProperties sentinelProperties;
    private final Environment env;

    public SentinelDataSourceHandler(DefaultListableBeanFactory beanFactory, SentinelProperties sentinelProperties, Environment env) {
        this.beanFactory = beanFactory;
        this.sentinelProperties = sentinelProperties;
        this.env = env;
    }

    public void afterSingletonsInstantiated() {
        this.sentinelProperties.getDatasource().forEach((dataSourceName, dataSourceProperties) -> {
            try {
                List validFields = dataSourceProperties.getValidField();
                if (validFields.size() != 1) {
                    log.error("[Sentinel Starter] DataSource " + dataSourceName + " multi datasource active and won't loaded: " + dataSourceProperties.getValidField());
                    return;
                }
                AbstractDataSourceProperties abstractDataSourceProperties = dataSourceProperties.getValidDataSourceProperties();
                abstractDataSourceProperties.setEnv(this.env);
                abstractDataSourceProperties.preCheck(dataSourceName);
                this.registerBean(abstractDataSourceProperties, dataSourceName + "-sentinel-" + (String)validFields.get(0) + "-datasource");
            }
            catch (Exception e) {
                log.error("[Sentinel Starter] DataSource " + dataSourceName + " build error: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    protected BeanDefinitionBuilder parseBeanDefinition(AbstractDataSourceProperties dataSourceProperties, String dataSourceName) {
        Map propertyMap = Arrays.stream(dataSourceProperties.getClass().getDeclaredFields()).filter(field -> !field.isSynthetic()).collect(HashMap::new, (m, v) -> {
            try {
                v.setAccessible(true);
                m.put(v.getName(), v.get(dataSourceProperties));
            }
            catch (IllegalAccessException e) {
                log.error("[Sentinel Starter] DataSource " + dataSourceName + " field: " + v.getName() + " invoke error");
                throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " field: " + v.getName() + " invoke error", e);
            }
        }, HashMap::putAll);
        propertyMap.put("converterClass", dataSourceProperties.getConverterClass());
        propertyMap.put("dataType", dataSourceProperties.getDataType());
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)dataSourceProperties.getFactoryBeanName());
        propertyMap.forEach((propertyName, propertyValue) -> {
            Field field = ReflectionUtils.findField(dataSourceProperties.getClass(), (String)propertyName);
            if (null == field) {
                return;
            }
            if ("dataType".equals(propertyName)) {
                String dataType = StringUtils.trimAllWhitespace((String)propertyValue.toString());
                if ("custom".equals(dataType)) {
                    try {
                        if (StringUtils.isEmpty((Object)dataSourceProperties.getConverterClass())) {
                            throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + "dataType is custom, please set converter-class property");
                        }
                        String customConvertBeanName = "sentinel-" + dataSourceProperties.getConverterClass();
                        if (!this.beanFactory.containsBean(customConvertBeanName)) {
                            this.beanFactory.registerBeanDefinition(customConvertBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(Class.forName(dataSourceProperties.getConverterClass())).getBeanDefinition());
                        }
                        builder.addPropertyReference("converter", customConvertBeanName);
                    }
                    catch (ClassNotFoundException e) {
                        log.error("[Sentinel Starter] DataSource " + dataSourceName + " handle " + dataSourceProperties.getClass().getSimpleName() + " error, class name: " + dataSourceProperties.getConverterClass());
                        throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " handle " + dataSourceProperties.getClass().getSimpleName() + " error, class name: " + dataSourceProperties.getConverterClass(), e);
                    }
                } else {
                    if (!this.dataTypeList.contains(StringUtils.trimAllWhitespace((String)propertyValue.toString()))) {
                        throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " dataType: " + propertyValue + " is not support now. please using these types: " + this.dataTypeList.toString());
                    }
                    builder.addPropertyReference("converter", "sentinel-" + propertyValue.toString() + "-" + dataSourceProperties.getRuleType().getName() + "-converter");
                }
            } else if (!"converterClass".equals(propertyName)) {
                Optional.ofNullable(propertyValue).ifPresent(v -> builder.addPropertyValue(propertyName, v));
            }
        });
        return builder;
    }

    private void registerBean(AbstractDataSourceProperties dataSourceProperties, String dataSourceName) {
        BeanDefinitionBuilder builder = this.parseBeanDefinition(dataSourceProperties, dataSourceName);
        this.beanFactory.registerBeanDefinition(dataSourceName, (BeanDefinition)builder.getBeanDefinition());
        AbstractDataSource newDataSource = (AbstractDataSource)this.beanFactory.getBean(dataSourceName);
        dataSourceProperties.postRegister(newDataSource);
    }
}

