/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Objects;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.event.EventListener;

public class NacosServiceManager {
    private NacosDiscoveryProperties nacosDiscoveryPropertiesCache;
    private NamingService namingService;
    private NamingMaintainService namingMaintainService;

    public NamingService getNamingService(Properties properties) {
        if (Objects.isNull(this.namingService)) {
            this.buildNamingService(properties);
        }
        return this.namingService;
    }

    public NamingMaintainService getNamingMaintainService(Properties properties) {
        if (Objects.isNull(this.namingMaintainService)) {
            this.buildNamingMaintainService(properties);
        }
        return this.namingMaintainService;
    }

    public boolean isNacosDiscoveryInfoChanged(NacosDiscoveryProperties nacosDiscoveryProperties) {
        if (Objects.isNull(this.nacosDiscoveryPropertiesCache) || this.nacosDiscoveryPropertiesCache.equals(nacosDiscoveryProperties)) {
            return false;
        }
        BeanUtils.copyProperties((Object)nacosDiscoveryProperties, (Object)this.nacosDiscoveryPropertiesCache);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamingMaintainService buildNamingMaintainService(Properties properties) {
        if (!Objects.isNull(this.namingMaintainService)) return this.namingMaintainService;
        Class<NacosServiceManager> clazz = NacosServiceManager.class;
        synchronized (NacosServiceManager.class) {
            if (!Objects.isNull(this.namingMaintainService)) return this.namingMaintainService;
            this.namingMaintainService = this.createNamingMaintainService(properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.namingMaintainService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamingService buildNamingService(Properties properties) {
        if (!Objects.isNull(this.namingService)) return this.namingService;
        Class<NacosServiceManager> clazz = NacosServiceManager.class;
        synchronized (NacosServiceManager.class) {
            if (!Objects.isNull(this.namingService)) return this.namingService;
            this.namingService = this.createNewNamingService(properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.namingService;
        }
    }

    private NamingService createNewNamingService(Properties properties) {
        try {
            return NacosFactory.createNamingService((Properties)properties);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    private NamingMaintainService createNamingMaintainService(Properties properties) {
        try {
            return NacosFactory.createMaintainService((Properties)properties);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    public void reBuildNacosService(Properties nacosProperties) {
        this.namingService = this.createNewNamingService(nacosProperties);
        this.namingMaintainService = this.createNamingMaintainService(nacosProperties);
    }

    public void nacosServiceShutDown() throws NacosException {
        this.namingService.shutDown();
    }

    @EventListener
    public void onInstancePreRegisteredEvent(InstancePreRegisteredEvent instancePreRegisteredEvent) {
        Registration registration = instancePreRegisteredEvent.getRegistration();
        if (Objects.isNull(this.nacosDiscoveryPropertiesCache) && registration instanceof NacosRegistration) {
            NacosDiscoveryProperties nacosDiscoveryProperties = ((NacosRegistration)registration).getNacosDiscoveryProperties();
            this.nacosDiscoveryPropertiesCache = new NacosDiscoveryProperties();
            BeanUtils.copyProperties((Object)nacosDiscoveryProperties, (Object)this.nacosDiscoveryPropertiesCache);
        }
    }
}

