/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.sms.base;

import com.alibaba.alicloud.sms.base.MessageListener;
import com.alibaba.alicloud.sms.base.TokenForAlicom;
import com.alibaba.alicloud.sms.base.TokenGetterForAlicom;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.Message;
import com.aliyuncs.exceptions.ClientException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAlicomMessagePuller {
    private static final Logger log = LoggerFactory.getLogger(DefaultAlicomMessagePuller.class);
    private String mnsAccountEndpoint = "https://1943695596114318.mns.cn-hangzhou.aliyuncs.com/";
    private String endpointNameForPop = "cn-hangzhou";
    private String regionIdForPop = "cn-hangzhou";
    private String domainForPop = "dybaseapi.aliyuncs.com";
    private TokenGetterForAlicom tokenGetter;
    private MessageListener messageListener;
    private boolean isRunning = false;
    private Integer pullMsgThreadSize = 1;
    private boolean debugLogOpen = false;
    private Integer sleepSecondWhenNoData = 30;
    private ExecutorService executorService;
    protected static final Map<String, Object> S_LOCK_OBJ_MAP = new HashMap<String, Object>();
    protected static Map<String, Boolean> sPollingMap = new ConcurrentHashMap<String, Boolean>();
    protected Object lockObj;

    public void openDebugLog(boolean debugLogOpen) {
        this.debugLogOpen = debugLogOpen;
    }

    public Integer getSleepSecondWhenNoData() {
        return this.sleepSecondWhenNoData;
    }

    public void setSleepSecondWhenNoData(Integer sleepSecondWhenNoData) {
        this.sleepSecondWhenNoData = sleepSecondWhenNoData;
    }

    public Integer getPullMsgThreadSize() {
        return this.pullMsgThreadSize;
    }

    public void setPullMsgThreadSize(Integer pullMsgThreadSize) {
        if (pullMsgThreadSize != null && pullMsgThreadSize > 1) {
            this.pullMsgThreadSize = pullMsgThreadSize;
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPolling(String queueName) {
        Object object = this.lockObj;
        synchronized (object) {
            Boolean ret = sPollingMap.get(queueName);
            if (ret == null || !ret.booleanValue()) {
                sPollingMap.put(queueName, true);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPolling(String queueName) {
        Object object = this.lockObj;
        synchronized (object) {
            sPollingMap.put(queueName, false);
            this.lockObj.notifyAll();
            if (this.debugLogOpen) {
                log.info("PullMessageTask_WakeUp:Everyone WakeUp and Work!");
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReceiveMsg(String accessKeyId, String accessKeySecret, String messageType, String queueName, MessageListener messageListener) throws ClientException, ParseException {
        this.tokenGetter = new TokenGetterForAlicom(accessKeyId, accessKeySecret, this.endpointNameForPop, this.regionIdForPop, this.domainForPop, null);
        this.messageListener = messageListener;
        this.isRunning = true;
        PullMessageTask task = new PullMessageTask();
        task.messageType = messageType;
        task.queueName = queueName;
        Map<String, Object> map = S_LOCK_OBJ_MAP;
        synchronized (map) {
            this.lockObj = S_LOCK_OBJ_MAP.get(queueName);
            if (this.lockObj == null) {
                this.lockObj = new Object();
                S_LOCK_OBJ_MAP.put(queueName, this.lockObj);
            }
        }
        if (this.executorService == null) {
            ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor((int)this.pullMsgThreadSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("PullMessageTask-" + messageType + "-thread-pool-%d").daemon(true).build());
            this.executorService = scheduledExecutorService;
        }
        for (int i = 0; i < this.pullMsgThreadSize; ++i) {
            this.executorService.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReceiveMsgForVPC(String accessKeyId, String accessKeySecret, String messageType, String queueName, String regionIdForPop, String endpointNameForPop, String domainForPop, String mnsAccountEndpoint, MessageListener messageListener) throws ClientException, ParseException {
        this.mnsAccountEndpoint = mnsAccountEndpoint;
        this.tokenGetter = new TokenGetterForAlicom(accessKeyId, accessKeySecret, endpointNameForPop, regionIdForPop, domainForPop, null);
        this.messageListener = messageListener;
        this.isRunning = true;
        PullMessageTask task = new PullMessageTask();
        task.messageType = messageType;
        task.queueName = queueName;
        Map<String, Object> map = S_LOCK_OBJ_MAP;
        synchronized (map) {
            this.lockObj = S_LOCK_OBJ_MAP.get(queueName);
            if (this.lockObj == null) {
                this.lockObj = new Object();
                S_LOCK_OBJ_MAP.put(queueName, this.lockObj);
            }
        }
        if (this.executorService == null) {
            ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor((int)this.pullMsgThreadSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("PullMessageTask-" + messageType + "-thread-pool-%d").daemon(true).build());
            this.executorService = scheduledExecutorService;
        }
        for (int i = 0; i < this.pullMsgThreadSize; ++i) {
            this.executorService.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReceiveMsgForPartnerUser(String accessKeyId, String accessKeySecret, Long ownerId, String messageType, String queueName, MessageListener messageListener) throws ClientException, ParseException {
        this.tokenGetter = new TokenGetterForAlicom(accessKeyId, accessKeySecret, this.endpointNameForPop, this.regionIdForPop, this.domainForPop, ownerId);
        this.messageListener = messageListener;
        this.isRunning = true;
        PullMessageTask task = new PullMessageTask();
        task.messageType = messageType;
        task.queueName = queueName;
        Map<String, Object> map = S_LOCK_OBJ_MAP;
        synchronized (map) {
            this.lockObj = S_LOCK_OBJ_MAP.get(queueName);
            if (this.lockObj == null) {
                this.lockObj = new Object();
                S_LOCK_OBJ_MAP.put(queueName, this.lockObj);
            }
        }
        if (this.executorService == null) {
            ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor((int)this.pullMsgThreadSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("PullMessageTask-" + messageType + "-thread-pool-%d").daemon(true).build());
            this.executorService = scheduledExecutorService;
        }
        for (int i = 0; i < this.pullMsgThreadSize; ++i) {
            this.executorService.execute(task);
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    private class PullMessageTask
    implements Runnable {
        private String messageType;
        private String queueName;

        private PullMessageTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean polling = false;
            while (DefaultAlicomMessagePuller.this.isRunning) {
                try {
                    boolean dealResult;
                    Object object = DefaultAlicomMessagePuller.this.lockObj;
                    synchronized (object) {
                        Boolean p = sPollingMap.get(this.queueName);
                        if (p != null && p.booleanValue()) {
                            try {
                                if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                                    log.info("PullMessageTask_sleep:" + Thread.currentThread().getName() + " Have a nice sleep!");
                                }
                                polling = false;
                                DefaultAlicomMessagePuller.this.lockObj.wait();
                            }
                            catch (InterruptedException e) {
                                if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                                    log.info("PullMessageTask_Interrupted!" + Thread.currentThread().getName() + " QueueName is " + this.queueName);
                                }
                                continue;
                            }
                        }
                    }
                    TokenForAlicom tokenObject = DefaultAlicomMessagePuller.this.tokenGetter.getTokenByMessageType(this.messageType, this.queueName, DefaultAlicomMessagePuller.this.mnsAccountEndpoint);
                    CloudQueue queue = tokenObject.getQueue();
                    Message popMsg = null;
                    if (!polling) {
                        popMsg = queue.popMessage();
                        if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            log.info("PullMessageTask_popMessage:" + Thread.currentThread().getName() + "-popDone at ," + format.format(new Date()) + " msgSize=" + (popMsg == null ? Integer.valueOf(0) : popMsg.getMessageId()));
                        }
                        if (popMsg == null) {
                            polling = true;
                            continue;
                        }
                    } else {
                        if (!DefaultAlicomMessagePuller.this.setPolling(this.queueName)) continue;
                        if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                            log.info("PullMessageTask_setPolling:" + Thread.currentThread().getName() + " Polling!");
                        }
                        do {
                            if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                                log.info("PullMessageTask_Keep_Polling" + Thread.currentThread().getName() + "KEEP Polling!");
                            }
                            try {
                                popMsg = queue.popMessage(DefaultAlicomMessagePuller.this.sleepSecondWhenNoData.intValue());
                            }
                            catch (com.aliyun.mns.common.ClientException e) {
                                if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                                    log.info("PullMessageTask_Pop_Message:ClientException Refresh accessKey" + (Object)((Object)e));
                                }
                                tokenObject = DefaultAlicomMessagePuller.this.tokenGetter.getTokenByMessageType(this.messageType, this.queueName, DefaultAlicomMessagePuller.this.mnsAccountEndpoint);
                                queue = tokenObject.getQueue();
                            }
                            catch (ServiceException e) {
                                if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                                    log.info("PullMessageTask_Pop_Message:ServiceException Refresh accessKey" + (Object)((Object)e));
                                }
                                tokenObject = DefaultAlicomMessagePuller.this.tokenGetter.getTokenByMessageType(this.messageType, this.queueName, DefaultAlicomMessagePuller.this.mnsAccountEndpoint);
                                queue = tokenObject.getQueue();
                            }
                            catch (Exception e) {
                                if (!DefaultAlicomMessagePuller.this.debugLogOpen) continue;
                                log.info("PullMessageTask_Pop_Message:Exception Happened when polling popMessage: " + e);
                            }
                        } while (popMsg == null && DefaultAlicomMessagePuller.this.isRunning);
                        DefaultAlicomMessagePuller.this.clearPolling(this.queueName);
                    }
                    if (!(dealResult = DefaultAlicomMessagePuller.this.messageListener.dealMessage(popMsg))) continue;
                    if (DefaultAlicomMessagePuller.this.debugLogOpen) {
                        log.info("PullMessageTask_Deal_Message:" + Thread.currentThread().getName() + "deleteMessage " + popMsg.getMessageId());
                    }
                    queue.deleteMessage(popMsg.getReceiptHandle());
                }
                catch (com.aliyun.mns.common.ClientException e) {
                    log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName, (Throwable)e);
                    break;
                }
                catch (ServiceException e) {
                    if (e.getErrorCode().equals("AccessDenied")) {
                        log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName + ",please check messageType and queueName", (Throwable)e);
                        break;
                    }
                    log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName, (Throwable)e);
                    break;
                }
                catch (ClientException e) {
                    if (e.getErrCode().equals("InvalidAccessKeyId.NotFound")) {
                        log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName + ",please check AccessKeyId", (Throwable)e);
                    }
                    if (e.getErrCode().equals("SignatureDoesNotMatch")) {
                        log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName + ",please check AccessKeySecret", (Throwable)e);
                        break;
                    }
                    log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName, (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName, (Throwable)e);
                    try {
                        Thread.sleep(DefaultAlicomMessagePuller.this.sleepSecondWhenNoData.intValue());
                    }
                    catch (InterruptedException e1) {
                        log.error("PullMessageTask_execute_error,messageType:" + this.messageType + ",queueName:" + this.queueName, (Throwable)e);
                    }
                }
            }
        }
    }
}

