/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.sms;

import com.alibaba.alicloud.context.sms.SmsProperties;
import com.alibaba.alicloud.sms.ISmsService;
import com.alibaba.alicloud.sms.SmsReportMessageListener;
import com.alibaba.alicloud.sms.SmsUpMessageListener;
import com.alibaba.alicloud.sms.base.MessageListener;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class SmsInitializerEventListener
implements ApplicationListener<ApplicationStartedEvent> {
    private final AtomicBoolean isCalled = new AtomicBoolean(false);
    private SmsProperties msConfigProperties;
    private ISmsService smsService;

    public SmsInitializerEventListener(SmsProperties msConfigProperties, ISmsService smsService) {
        this.msConfigProperties = msConfigProperties;
        this.smsService = smsService;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (!this.isCalled.compareAndSet(false, true)) {
            return;
        }
        System.setProperty("sun.net.client.defaultConnectTimeout", this.msConfigProperties.getConnectTimeout());
        System.setProperty("sun.net.client.defaultReadTimeout", this.msConfigProperties.getReadTimeout());
        try {
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Dysmsapi", (String)"dysmsapi.aliyuncs.com");
            Collection messageListeners = event.getApplicationContext().getBeansOfType(MessageListener.class).values();
            if (messageListeners.isEmpty()) {
                return;
            }
            for (MessageListener messageListener : messageListeners) {
                if (SmsReportMessageListener.class.isInstance(messageListener)) {
                    if (this.msConfigProperties.getReportQueueName() != null && this.msConfigProperties.getReportQueueName().trim().length() > 0) {
                        this.smsService.startSmsReportMessageListener((SmsReportMessageListener)messageListener);
                        continue;
                    }
                    throw new IllegalArgumentException("the SmsReport queue name for " + messageListener.getClass().getCanonicalName() + " must be set.");
                }
                if (!SmsUpMessageListener.class.isInstance(messageListener)) continue;
                if (this.msConfigProperties.getUpQueueName() != null && this.msConfigProperties.getUpQueueName().trim().length() > 0) {
                    this.smsService.startSmsUpMessageListener((SmsUpMessageListener)messageListener);
                    continue;
                }
                throw new IllegalArgumentException("the SmsUp queue name for " + messageListener.getClass().getCanonicalName() + " must be set.");
            }
        }
        catch (ClientException e) {
            throw new RuntimeException("initialize sms profile end point cause an exception");
        }
    }
}

