/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.sms.endpoint;

import com.alibaba.alicloud.sms.endpoint.ReceiveMessageEntity;
import com.aliyuncs.dysmsapi.model.v20170525.SendBatchSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;

public final class EndpointManager {
    private static final int BACKLOG_SIZE = 20;
    private static final ReentrantLock SEND_REENTRANT_LOCK = new ReentrantLock(true);
    private static final ReentrantLock SEND_BATCH_REENTRANT_LOCK = new ReentrantLock(true);
    private static final LinkedBlockingQueue<SendSmsRequest> SEND_SMS_REQUESTS = new LinkedBlockingQueue(20);
    private static final LinkedBlockingQueue<SendBatchSmsRequest> SEND_BATCH_SMS_REQUESTS = new LinkedBlockingQueue(20);
    private static final LinkedBlockingQueue<ReceiveMessageEntity> RECEIVE_MESSAGE_ENTITIES = new LinkedBlockingQueue(20);

    public static void addSendSmsRequest(SendSmsRequest sendSmsRequest) {
        if (SEND_SMS_REQUESTS.offer(sendSmsRequest)) {
            return;
        }
        try {
            SEND_REENTRANT_LOCK.lock();
            SEND_SMS_REQUESTS.poll();
            SEND_SMS_REQUESTS.offer(sendSmsRequest);
        }
        finally {
            SEND_REENTRANT_LOCK.unlock();
        }
    }

    public static void addSendBatchSmsRequest(SendBatchSmsRequest sendBatchSmsRequest) {
        if (SEND_BATCH_SMS_REQUESTS.offer(sendBatchSmsRequest)) {
            return;
        }
        try {
            SEND_BATCH_REENTRANT_LOCK.lock();
            SEND_BATCH_SMS_REQUESTS.poll();
            SEND_BATCH_SMS_REQUESTS.offer(sendBatchSmsRequest);
        }
        finally {
            SEND_BATCH_REENTRANT_LOCK.unlock();
        }
    }

    public static void addReceiveMessageEntity(ReceiveMessageEntity receiveMessageEntity) {
        if (RECEIVE_MESSAGE_ENTITIES.offer(receiveMessageEntity)) {
            return;
        }
        RECEIVE_MESSAGE_ENTITIES.poll();
        RECEIVE_MESSAGE_ENTITIES.offer(receiveMessageEntity);
    }

    public static Map<String, Object> getSmsEndpointMessage() {
        LinkedList<SendSmsRequest> sendSmsRequests = new LinkedList<SendSmsRequest>();
        LinkedList<SendBatchSmsRequest> sendBatchSmsRequests = new LinkedList<SendBatchSmsRequest>();
        LinkedList<ReceiveMessageEntity> receiveMessageEntities = new LinkedList<ReceiveMessageEntity>();
        try {
            SEND_REENTRANT_LOCK.lock();
            SEND_BATCH_REENTRANT_LOCK.lock();
            sendSmsRequests.addAll(SEND_SMS_REQUESTS);
            sendBatchSmsRequests.addAll(SEND_BATCH_SMS_REQUESTS);
        }
        finally {
            SEND_REENTRANT_LOCK.unlock();
            SEND_BATCH_REENTRANT_LOCK.unlock();
        }
        receiveMessageEntities.addAll(RECEIVE_MESSAGE_ENTITIES);
        HashMap<String, Object> endpointMessages = new HashMap<String, Object>();
        endpointMessages.put("send-sms-request", sendSmsRequests);
        endpointMessages.put("send-batch-sms-request", sendBatchSmsRequests);
        endpointMessages.put("message-listener", receiveMessageEntities);
        return endpointMessages;
    }
}

