/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.oss.resource;

import com.alibaba.alicloud.oss.resource.OssStorageResource;
import com.aliyun.oss.OSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class OssStorageProtocolResolver
implements ProtocolResolver,
BeanFactoryPostProcessor,
ResourceLoaderAware {
    public static final String PROTOCOL = "oss://";
    private static final Logger log = LoggerFactory.getLogger(OssStorageProtocolResolver.class);
    private ConfigurableListableBeanFactory beanFactory;
    private OSS oss;

    private OSS getOSS() {
        if (this.oss == null) {
            if (this.beanFactory.getBeansOfType(OSS.class).size() > 1) {
                log.warn("There are multiple OSS instances, consider marking one of them as @Primary to resolve oss protocol.");
            }
            this.oss = (OSS)this.beanFactory.getBean(OSS.class);
        }
        return this.oss;
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (!location.startsWith(PROTOCOL)) {
            return null;
        }
        return new OssStorageResource(this.getOSS(), location, this.beanFactory);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (DefaultResourceLoader.class.isAssignableFrom(resourceLoader.getClass())) {
            ((DefaultResourceLoader)resourceLoader).addProtocolResolver((ProtocolResolver)this);
        } else {
            log.warn("The provided delegate resource loader is not an implementation of DefaultResourceLoader. Custom Protocol using oss:// prefix will not be enabled.");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

