/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.oss;

import com.alibaba.alicloud.oss.resource.OssStorageProtocolResolver;
import com.aliyun.oss.OSS;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OSS.class})
@ConditionalOnProperty(name={"spring.cloud.alibaba.oss.enabled"}, havingValue="true", matchIfMissing=true)
public class OssAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OssStorageProtocolResolver ossStorageProtocolResolver() {
        return new OssStorageProtocolResolver();
    }

    @Bean(name={"ossTaskExecutor"})
    @ConditionalOnMissingBean
    public ExecutorService ossTaskExecutor() {
        int coreSize = Runtime.getRuntime().availableProcessors();
        return new ThreadPoolExecutor(coreSize, 128, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }
}

