/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.context.listener;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;

public abstract class AbstractOnceApplicationListener<T extends ApplicationEvent>
implements ApplicationListener<T> {
    private static final String BOOTSTRAP_CONFIG_NAME_VALUE = "bootstrap";
    private static final String BOOTSTRAP_CONFIG_NAME_KEY = "spring.config.name";
    private static ConcurrentHashMap<Class<?>, AtomicBoolean> lockMap = new ConcurrentHashMap();

    public void onApplicationEvent(T event) {
        ApplicationContext applicationContext;
        if (event instanceof ApplicationContextEvent && BOOTSTRAP_CONFIG_NAME_VALUE.equals((applicationContext = ((ApplicationContextEvent)event).getApplicationContext()).getEnvironment().getProperty(BOOTSTRAP_CONFIG_NAME_KEY))) {
            return;
        }
        Class<?> clazz = this.getClass();
        lockMap.putIfAbsent(clazz, new AtomicBoolean(false));
        AtomicBoolean handled = lockMap.get(clazz);
        if (!handled.compareAndSet(false, true)) {
            return;
        }
        if (this.conditionalOnClass() != null) {
            try {
                Class.forName(this.conditionalOnClass());
            }
            catch (ClassNotFoundException e) {
                return;
            }
        }
        this.handleEvent(event);
    }

    protected abstract void handleEvent(T var1);

    protected String conditionalOnClass() {
        return null;
    }
}

