/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.gateway.zuul;

import com.alibaba.cloud.sentinel.gateway.zuul.FallBackProviderHandler;
import com.alibaba.cloud.sentinel.gateway.zuul.SentinelZuulProperties;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.callback.ZuulGatewayCallbackManager;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.filters.SentinelZuulErrorFilter;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.filters.SentinelZuulPostFilter;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.filters.SentinelZuulPreFilter;
import com.netflix.zuul.http.ZuulServlet;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ZuulServlet.class})
@ConditionalOnProperty(prefix="spring.cloud.sentinel.zuul", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelZuulProperties.class})
public class SentinelZuulAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SentinelZuulAutoConfiguration.class);
    @Autowired
    private Optional<RequestOriginParser> requestOriginParserOptional;
    @Autowired
    private SentinelZuulProperties zuulProperties;

    @PostConstruct
    private void init() {
        this.requestOriginParserOptional.ifPresent(ZuulGatewayCallbackManager::setOriginParser);
        System.setProperty("csp.sentinel.app.type", String.valueOf("12"));
    }

    @Bean
    @ConditionalOnMissingBean
    public SentinelZuulPreFilter sentinelZuulPreFilter() {
        logger.info("[Sentinel Zuul] register SentinelZuulPreFilter {}", (Object)this.zuulProperties.getOrder().getPre());
        return new SentinelZuulPreFilter(this.zuulProperties.getOrder().getPre());
    }

    @Bean
    @ConditionalOnMissingBean
    public SentinelZuulPostFilter sentinelZuulPostFilter() {
        logger.info("[Sentinel Zuul] register SentinelZuulPostFilter {}", (Object)this.zuulProperties.getOrder().getPost());
        return new SentinelZuulPostFilter(this.zuulProperties.getOrder().getPost());
    }

    @Bean
    @ConditionalOnMissingBean
    public SentinelZuulErrorFilter sentinelZuulErrorFilter() {
        logger.info("[Sentinel Zuul] register SentinelZuulErrorFilter {}", (Object)this.zuulProperties.getOrder().getError());
        return new SentinelZuulErrorFilter(this.zuulProperties.getOrder().getError());
    }

    @Bean
    public FallBackProviderHandler fallBackProviderHandler(DefaultListableBeanFactory beanFactory) {
        return new FallBackProviderHandler(beanFactory);
    }
}

