/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery.reactive;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NacosReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(NacosReactiveDiscoveryClient.class);
    private NacosServiceDiscovery serviceDiscovery;

    public NacosReactiveDiscoveryClient(NacosServiceDiscovery nacosServiceDiscovery) {
        this.serviceDiscovery = nacosServiceDiscovery;
    }

    public String description() {
        return "Spring Cloud Nacos Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Mono.justOrEmpty((Object)serviceId).flatMapMany(this.loadInstancesFromNacos());
    }

    private Function<String, Publisher<ServiceInstance>> loadInstancesFromNacos() {
        return serviceId -> {
            try {
                return Flux.fromIterable(this.serviceDiscovery.getInstances((String)serviceId));
            }
            catch (NacosException e) {
                log.error("get service instance[{}] from nacos error!", serviceId, (Object)e);
                return Flux.empty();
            }
        };
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> {
            try {
                return Flux.fromIterable(this.serviceDiscovery.getServices());
            }
            catch (Exception e) {
                log.error("get services from nacos server fail,", (Throwable)e);
                return Flux.empty();
            }
        });
    }
}

