/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.metadata.resolver;

import com.alibaba.cloud.dubbo.metadata.MethodMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.metadata.ServiceRestMetadata;
import com.alibaba.cloud.dubbo.metadata.resolver.MetadataResolver;
import feign.Contract;
import feign.Feign;
import feign.Util;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.spring.ServiceBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.util.ClassUtils;

public class DubboServiceBeanMetadataResolver
implements BeanClassLoaderAware,
SmartInitializingSingleton,
MetadataResolver {
    private static final String[] CONTRACT_CLASS_NAMES = new String[]{"feign.jaxrs2.JAXRS2Contract", "org.springframework.cloud.openfeign.support.SpringMvcContract"};
    private final ObjectProvider<Contract> contractObjectProvider;
    private ClassLoader classLoader;
    private Collection<Contract> contracts;

    public DubboServiceBeanMetadataResolver(ObjectProvider<Contract> contractObjectProvider) {
        this.contractObjectProvider = contractObjectProvider;
    }

    public void afterSingletonsInstantiated() {
        LinkedList<Contract> contracts = new LinkedList<Contract>();
        Contract contract = (Contract)this.contractObjectProvider.getIfAvailable();
        if (contract != null) {
            contracts.add(contract);
        }
        Stream.of(CONTRACT_CLASS_NAMES).filter(this::isClassPresent).map(this::loadContractClass).map(this::createContract).forEach(contracts::add);
        this.contracts = Collections.unmodifiableCollection(contracts);
    }

    private Contract createContract(Class<?> contractClassName) {
        return (Contract)BeanUtils.instantiateClass(contractClassName);
    }

    private Class<?> loadContractClass(String contractClassName) {
        return ClassUtils.resolveClassName((String)contractClassName, (ClassLoader)this.classLoader);
    }

    private boolean isClassPresent(String className) {
        return ClassUtils.isPresent((String)className, (ClassLoader)this.classLoader);
    }

    @Override
    public Set<ServiceRestMetadata> resolveServiceRestMetadata(ServiceBean serviceBean) {
        Object bean = serviceBean.getRef();
        Class<?> beanType = bean.getClass();
        LinkedHashSet<ServiceRestMetadata> serviceRestMetadata = new LinkedHashSet<ServiceRestMetadata>();
        Set<RestMethodMetadata> methodRestMetadata = this.resolveMethodRestMetadata(beanType);
        List urls = serviceBean.getExportedUrls();
        urls.stream().map(URL::toString).forEach(url -> {
            ServiceRestMetadata metadata = new ServiceRestMetadata();
            metadata.setUrl((String)url);
            metadata.setMeta(methodRestMetadata);
            serviceRestMetadata.add(metadata);
        });
        return serviceRestMetadata;
    }

    @Override
    public Set<RestMethodMetadata> resolveMethodRestMetadata(Class<?> targetType) {
        List<Method> feignContractMethods = this.selectFeignContractMethods(targetType);
        return this.contracts.stream().map(contract -> this.parseAndValidateMetadata((Contract)contract, targetType)).flatMap(v -> v.stream()).map(methodMetadata -> this.resolveMethodRestMetadata((feign.MethodMetadata)methodMetadata, targetType, feignContractMethods)).collect(Collectors.toSet());
    }

    private List<feign.MethodMetadata> parseAndValidateMetadata(Contract contract, Class<?> targetType) {
        List methodMetadataList = Collections.emptyList();
        try {
            methodMetadataList = contract.parseAndValidatateMetadata(targetType);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return methodMetadataList;
    }

    private List<Method> selectFeignContractMethods(Class<?> targetType) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method method : targetType.getMethods()) {
            if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || Util.isDefault((Method)method)) continue;
            methods.add(method);
        }
        return methods;
    }

    protected RestMethodMetadata resolveMethodRestMetadata(feign.MethodMetadata methodMetadata, Class<?> targetType, List<Method> feignContractMethods) {
        String configKey = methodMetadata.configKey();
        Method feignContractMethod = this.getMatchedFeignContractMethod(targetType, feignContractMethods, configKey);
        RestMethodMetadata metadata = new RestMethodMetadata(methodMetadata);
        metadata.setMethod(new MethodMetadata(feignContractMethod));
        return metadata;
    }

    private Method getMatchedFeignContractMethod(Class<?> targetType, List<Method> methods, String expectedConfigKey) {
        Method matchedMethod = null;
        for (Method method : methods) {
            String configKey = Feign.configKey(targetType, (Method)method);
            if (!expectedConfigKey.equals(configKey)) continue;
            matchedMethod = method;
            break;
        }
        return matchedMethod;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

