/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.acm;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.acm.AcmConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfigurationFactory;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.utils.AssertUtils;
import com.alibaba.edas.acm.ConfigService;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliCloudAcmInitializer {
    private static final Logger log = LoggerFactory.getLogger(AliCloudAcmInitializer.class);

    private AliCloudAcmInitializer() {
    }

    public static void initialize(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, AcmConfiguration acmConfiguration) {
        Properties properties = new Properties();
        EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory.getEdasChangeOrderConfiguration();
        if (edasChangeOrderConfiguration.isEdasManaged()) {
            log.info("Initialize acm from edas change order.");
            AliCloudAcmInitializer.initializeFromEdasChangeOrder(properties, edasChangeOrderConfiguration);
        } else if (edasConfiguration.isEnabled() || acmConfiguration.getServerMode() == AliCloudServerMode.EDAS) {
            log.info("Initialize acm from pop api.");
            AliCloudAcmInitializer.initializeFromPopApi(properties, aliCloudConfiguration, acmConfiguration);
        } else {
            log.info("Initialize acm from acm configuration.");
            AliCloudAcmInitializer.initializeFromAcmConfiguration(acmConfiguration);
        }
        ConfigService.init((Properties)properties);
    }

    private static void initializeFromEdasChangeOrder(Properties properties, EdasChangeOrderConfiguration edasChangeOrderConfiguration) {
        properties.put("endpoint", edasChangeOrderConfiguration.getAddressServerDomain());
        properties.put("namespace", edasChangeOrderConfiguration.getTenantId());
        properties.put("accessKey", edasChangeOrderConfiguration.getDauthAccessKey());
        properties.put("secretKey", edasChangeOrderConfiguration.getDauthSecretKey());
    }

    private static void initializeFromPopApi(Properties properties, AliCloudConfiguration aliCloudConfiguration, AcmConfiguration acmConfiguration) {
        AssertUtils.notNull(aliCloudConfiguration.getAccessKey(), "Access key can't be null.");
        AssertUtils.notNull(aliCloudConfiguration.getSecretKey(), "Secret key can't be null.");
        AssertUtils.notNull(acmConfiguration.getNamespace(), "Namespace can't be null.");
        AssertUtils.notNull(acmConfiguration.getEndpoint(), "Endpoint can't be empty.");
        properties.put("endpoint", acmConfiguration.getEndpoint());
        properties.put("namespace", acmConfiguration.getNamespace());
        properties.put("accessKey", aliCloudConfiguration.getAccessKey());
        properties.put("secretKey", aliCloudConfiguration.getSecretKey());
    }

    private static void initializeFromAcmConfiguration(AcmConfiguration acmConfiguration) {
        if (null != acmConfiguration.getServerList()) {
            System.setProperty("DIAMOND.SERVER.IPS", acmConfiguration.getServerList());
        }
        if (null != acmConfiguration.getServerPort()) {
            System.setProperty("diamond.server.port", acmConfiguration.getServerPort());
        }
    }
}

