/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag.validation;

import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentCloudReaderConfig;
import com.alibaba.cloud.ai.dashscope.rag.exception.FileSizeExceededException;
import com.alibaba.cloud.ai.dashscope.rag.exception.FileSizeTooSmallException;
import com.alibaba.cloud.ai.dashscope.rag.util.FileSizeFormatter;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileValidator {
    private static final Logger logger = LoggerFactory.getLogger(FileValidator.class);
    private final DashScopeDocumentCloudReaderConfig clientConfig;

    public FileValidator(DashScopeDocumentCloudReaderConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void validate(File file) {
        this.validateFileExists(file);
        this.validateFileType(file);
        this.validateFileReadable(file);
        this.validateFileSize(file);
    }

    private void validateFileExists(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file.getAbsolutePath());
        }
    }

    private void validateFileType(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Path is not a file: " + file.getAbsolutePath());
        }
    }

    private void validateFileReadable(File file) {
        if (!file.canRead()) {
            throw new IllegalArgumentException("File is not readable: " + file.getAbsolutePath());
        }
    }

    private void validateFileSize(File file) {
        if (!this.clientConfig.isEnableFileSizeValidation()) {
            logger.debug("File size validation is disabled for file: {}", (Object)file.getName());
            return;
        }
        long fileSize = file.length();
        long minSize = this.clientConfig.getMinFileSize();
        long maxSize = this.clientConfig.getMaxFileSize();
        if (fileSize < minSize) {
            logger.error("File size {} is below minimum {}: {}", new Object[]{FileSizeFormatter.format(fileSize), FileSizeFormatter.format(minSize), file.getName()});
            throw new FileSizeTooSmallException(fileSize, minSize);
        }
        if (fileSize > maxSize) {
            logger.error("File size {} exceeds maximum {}: {}", new Object[]{FileSizeFormatter.format(fileSize), FileSizeFormatter.format(maxSize), file.getName()});
            throw new FileSizeExceededException(fileSize, maxSize);
        }
        logger.debug("File size validation passed: {} ({})", (Object)file.getName(), (Object)FileSizeFormatter.format(fileSize));
    }
}

