/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag.util;

public final class FileSizeFormatter {
    private static final long KILOBYTE = 1024L;
    private static final long MEGABYTE = 0x100000L;
    private static final long GIGABYTE = 0x40000000L;
    private static final long TERABYTE = 0x10000000000L;

    private FileSizeFormatter() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static String format(long bytes) {
        return FileSizeFormatter.format(bytes, 2);
    }

    public static String format(long bytes, int decimalPlaces) {
        if (decimalPlaces < 0 || decimalPlaces > 10) {
            throw new IllegalArgumentException("Decimal places must be between 0 and 10, got: " + decimalPlaces);
        }
        if (bytes < 0L) {
            return "Invalid size";
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return FileSizeFormatter.formatWithUnit(bytes, 1024L, "KB", decimalPlaces);
        }
        if (bytes < 0x40000000L) {
            return FileSizeFormatter.formatWithUnit(bytes, 0x100000L, "MB", decimalPlaces);
        }
        if (bytes < 0x10000000000L) {
            return FileSizeFormatter.formatWithUnit(bytes, 0x40000000L, "GB", decimalPlaces);
        }
        return FileSizeFormatter.formatWithUnit(bytes, 0x10000000000L, "TB", decimalPlaces);
    }

    private static String formatWithUnit(long bytes, long divisor, String unit, int decimalPlaces) {
        double value = (double)bytes / (double)divisor;
        String formatPattern = "%." + decimalPlaces + "f %s";
        return String.format(formatPattern, value, unit);
    }

    public static long parse(String sizeStr) {
        double number;
        String unitPart;
        String numberPart;
        if (sizeStr == null || sizeStr.trim().isEmpty()) {
            throw new IllegalArgumentException("Size string cannot be null or empty");
        }
        String trimmed = sizeStr.trim().toUpperCase();
        if ((trimmed = trimmed.replaceAll("\\s+", "")).matches("^[0-9.]+$")) {
            numberPart = trimmed;
            unitPart = "B";
        } else if (trimmed.matches("^[0-9.]+[A-Z]+$")) {
            int unitIndex = trimmed.length();
            for (int i = 0; i < trimmed.length(); ++i) {
                if (!Character.isLetter(trimmed.charAt(i))) continue;
                unitIndex = i;
                break;
            }
            numberPart = trimmed.substring(0, unitIndex);
            unitPart = trimmed.substring(unitIndex);
        } else {
            throw new IllegalArgumentException("Invalid size format: " + sizeStr);
        }
        try {
            number = Double.parseDouble(numberPart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format: " + numberPart, e);
        }
        return (long)(number * (double)(switch (unitPart) {
            case "B" -> 1L;
            case "KB", "K" -> 1024L;
            case "MB", "M" -> 0x100000L;
            case "GB", "G" -> 0x40000000L;
            case "TB", "T" -> 0x10000000000L;
            default -> throw new IllegalArgumentException("Unknown unit: " + unitPart);
        }));
    }

    public static String formatCompact(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            long kb = bytes / 1024L;
            return kb + " KB";
        }
        if (bytes < 0x40000000L) {
            long mb = bytes / 0x100000L;
            return mb + " MB";
        }
        if (bytes < 0x10000000000L) {
            long gb = bytes / 0x40000000L;
            return gb + " GB";
        }
        long tb = bytes / 0x10000000000L;
        return tb + " TB";
    }

    public static double toKilobytes(long bytes) {
        return (double)bytes / 1024.0;
    }

    public static double toMegabytes(long bytes) {
        return (double)bytes / 1048576.0;
    }

    public static double toGigabytes(long bytes) {
        return (double)bytes / 1.073741824E9;
    }

    public static double toTerabytes(long bytes) {
        return (double)bytes / 1.099511627776E12;
    }
}

