/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag.handler;

public enum FileStatus {
    PARSE_SUCCESS("PARSE_SUCCESS"),
    PARSE_FAILED("PARSE_FAILED"),
    PARSING("PARSING"),
    UPLOADED("UPLOADED"),
    UNK("UNK");

    private final String value;

    private FileStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSuccess() {
        return this == PARSE_SUCCESS;
    }

    public boolean isFailed() {
        return this == PARSE_FAILED;
    }

    public static FileStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        for (FileStatus status : FileStatus.values()) {
            if (!status.value.equals(value)) continue;
            return status;
        }
        return null;
    }

    public static FileStatus fromValueOrDefault(String value, FileStatus defaultStatus) {
        FileStatus status = FileStatus.fromValue(value);
        return status != null ? status : defaultStatus;
    }

    public String toString() {
        return this.value;
    }
}

