/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag.handler;

import com.alibaba.cloud.ai.dashscope.rag.context.DocumentProcessContext;
import com.alibaba.cloud.ai.dashscope.rag.handler.FileStatus;
import com.alibaba.cloud.ai.dashscope.rag.handler.FileStatusHandler;
import com.alibaba.cloud.ai.dashscope.rag.handler.FileStatusResult;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class DefaultFileStatusHandler
implements FileStatusHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFileStatusHandler.class);

    @Override
    public FileStatusResult handle(DocumentProcessContext context, ResponseEntity<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.QueryFileResponseData>> response) {
        DashScopeApiSpec.QueryFileResponseData data = (DashScopeApiSpec.QueryFileResponseData)((DashScopeApiSpec.CommonResponse)response.getBody()).data();
        String statusValue = data != null ? data.status() : null;
        FileStatus fileStatus = FileStatus.fromValueOrDefault(statusValue, FileStatus.UNK);
        if (fileStatus == null) {
            logger.warn("Received null status for file: {}, treating as PARSING", (Object)context.getFileId());
            return this.handleParsing(context);
        }
        return switch (fileStatus) {
            case FileStatus.PARSE_SUCCESS -> this.handleParseSuccess(context);
            case FileStatus.PARSE_FAILED -> this.handleParseFailed(context, response);
            case FileStatus.PARSING, FileStatus.UPLOADED -> FileStatusResult.inProgress();
            default -> {
                logger.warn("Unknown file status: {} for file: {}, treating as PARSING", (Object)statusValue, (Object)context.getFileId());
                yield this.handleParsing(context);
            }
        };
    }

    private FileStatusResult handleParseSuccess(DocumentProcessContext context) {
        logger.debug("File parsing succeeded for fileId: {}", (Object)context.getFileId());
        return FileStatusResult.success();
    }

    private FileStatusResult handleParseFailed(DocumentProcessContext context, ResponseEntity<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.QueryFileResponseData>> response) {
        DashScopeApiSpec.CommonResponse body = (DashScopeApiSpec.CommonResponse)response.getBody();
        if (body == null) {
            logger.error("File parsing failed. FileId: {}. Response body is null.", (Object)context.getFileId());
            String message = String.format("File parsing failed - FileId: %s. Response body is null.", context.getFileId());
            return FileStatusResult.failure(message);
        }
        String errorCode = body.code();
        String errorMessage = body.message();
        logger.error("File parsing failed. FileId: {}, ErrorCode: {}, ErrorMessage: {}", new Object[]{context.getFileId(), errorCode, errorMessage});
        String message = String.format("File parsing failed - FileId: %s, ErrorCode: %s, ErrorMessage: %s", context.getFileId(), errorCode, errorMessage);
        return FileStatusResult.failure(message);
    }

    private FileStatusResult handleParsing(DocumentProcessContext context) {
        logger.debug("File is still parsing. FileId: {}", (Object)context.getFileId());
        return FileStatusResult.inProgress();
    }
}

