/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag.exception;

import com.alibaba.cloud.ai.dashscope.rag.util.FileSizeFormatter;

public class FileSizeTooSmallException
extends IllegalArgumentException {
    private final long fileSize;
    private final long minFileSize;

    public FileSizeTooSmallException(long fileSize, long minFileSize) {
        super(String.format("File size (%s) is below minimum allowed size (%s)", FileSizeFormatter.format(fileSize), FileSizeFormatter.format(minFileSize)));
        this.fileSize = fileSize;
        this.minFileSize = minFileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getMinFileSize() {
        return this.minFileSize;
    }
}

