/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag.exception;

import com.alibaba.cloud.ai.dashscope.rag.util.FileSizeFormatter;

public class FileSizeExceededException
extends IllegalArgumentException {
    private final long fileSize;
    private final long maxFileSize;

    public FileSizeExceededException(long fileSize, long maxFileSize) {
        super(String.format("File size (%s) exceeds maximum allowed size (%s)", FileSizeFormatter.format(fileSize), FileSizeFormatter.format(maxFileSize)));
        this.fileSize = fileSize;
        this.maxFileSize = maxFileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }
}

