/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeDocumentRetrieverOptions {
    @JsonProperty(value="index_name")
    private String indexName;
    @JsonProperty(value="dense_similarity_top_k")
    private int denseSimilarityTopK = 100;
    @JsonProperty(value="sparse_similarity_top_k")
    private int sparseSimilarityTopK = 100;
    @JsonProperty(value="enable_rewrite")
    private boolean enableRewrite = false;
    @JsonProperty(value="model_name")
    private String rewriteModelName = "conv-rewrite-qwen-1.8b";
    @JsonProperty(value="enable_reranking")
    private boolean enableReranking = true;
    @JsonProperty(value="model_name")
    private String rerankModelName = "gte-rerank-hybrid";
    @JsonProperty(value="rerank_min_score")
    private float rerankMinScore = 0.01f;
    @JsonProperty(value="rerank_top_n")
    private int rerankTopN = 5;
    @JsonProperty(value="search_filters")
    private List<Map<String, Object>> searchFilters;

    public static Builder builder() {
        return new Builder();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public int getDenseSimilarityTopK() {
        return this.denseSimilarityTopK;
    }

    public void setDenseSimilarityTopK(int denseSimilarityTopK) {
        this.denseSimilarityTopK = denseSimilarityTopK;
    }

    public int getSparseSimilarityTopK() {
        return this.sparseSimilarityTopK;
    }

    public void setSparseSimilarityTopK(int sparseSimilarityTopK) {
        this.sparseSimilarityTopK = sparseSimilarityTopK;
    }

    public boolean isEnableRewrite() {
        return this.enableRewrite;
    }

    public void setEnableRewrite(boolean enableRewrite) {
        this.enableRewrite = enableRewrite;
    }

    public String getRewriteModelName() {
        return this.rewriteModelName;
    }

    public void setRewriteModelName(String rewriteModelName) {
        this.rewriteModelName = rewriteModelName;
    }

    public boolean isEnableReranking() {
        return this.enableReranking;
    }

    public void setEnableReranking(boolean enableReranking) {
        this.enableReranking = enableReranking;
    }

    public String getRerankModelName() {
        return this.rerankModelName;
    }

    public void setRerankModelName(String rerankModelName) {
        this.rerankModelName = rerankModelName;
    }

    public float getRerankMinScore() {
        return this.rerankMinScore;
    }

    public void setRerankMinScore(float rerankMinScore) {
        this.rerankMinScore = rerankMinScore;
    }

    public int getRerankTopN() {
        return this.rerankTopN;
    }

    public void setRerankTopN(int rerankTopN) {
        this.rerankTopN = rerankTopN;
    }

    public void setSearchFilters(List<Map<String, Object>> searchFilters) {
        this.searchFilters = searchFilters;
    }

    public List<Map<String, Object>> getSearchFilters() {
        return this.searchFilters;
    }

    public static class Builder {
        protected DashScopeDocumentRetrieverOptions options = new DashScopeDocumentRetrieverOptions();

        public Builder indexName(String indexName) {
            this.options.setIndexName(indexName);
            return this;
        }

        @Deprecated
        public Builder withIndexName(String indexName) {
            return this.indexName(indexName);
        }

        public Builder denseSimilarityTopK(Integer denseSimilarityTopK) {
            this.options.setDenseSimilarityTopK(denseSimilarityTopK);
            return this;
        }

        @Deprecated
        public Builder withDenseSimilarityTopK(Integer denseSimilarityTopK) {
            return this.denseSimilarityTopK(denseSimilarityTopK);
        }

        public Builder sparseSimilarityTopK(int sparseSimilarityTopK) {
            this.options.setSparseSimilarityTopK(sparseSimilarityTopK);
            return this;
        }

        @Deprecated
        public Builder withSparseSimilarityTopK(int sparseSimilarityTopK) {
            return this.sparseSimilarityTopK(sparseSimilarityTopK);
        }

        public Builder enableRewrite(boolean enableRewrite) {
            this.options.setEnableRewrite(enableRewrite);
            return this;
        }

        @Deprecated
        public Builder withEnableRewrite(boolean enableRewrite) {
            return this.enableRewrite(enableRewrite);
        }

        public Builder rewriteModelName(String rewriteModelName) {
            this.options.setRewriteModelName(rewriteModelName);
            return this;
        }

        @Deprecated
        public Builder withRewriteModelName(String rewriteModelName) {
            return this.rewriteModelName(rewriteModelName);
        }

        public Builder enableReranking(boolean enableReranking) {
            this.options.setEnableReranking(enableReranking);
            return this;
        }

        @Deprecated
        public Builder withEnableReranking(boolean enableReranking) {
            this.options.setEnableReranking(enableReranking);
            return this;
        }

        public Builder rerankModelName(String textType) {
            this.options.setRerankModelName(textType);
            return this;
        }

        @Deprecated
        public Builder withRerankModelName(String textType) {
            return this.rerankModelName(textType);
        }

        public Builder rerankMinScore(float rerankMinScore) {
            this.options.setRerankMinScore(rerankMinScore);
            return this;
        }

        @Deprecated
        public Builder withRerankMinScore(float rerankMinScore) {
            return this.rerankMinScore(rerankMinScore);
        }

        public Builder rerankTopN(int rerankTopN) {
            this.options.setRerankTopN(rerankTopN);
            return this;
        }

        @Deprecated
        public Builder withRerankTopN(int rerankTopN) {
            return this.rerankTopN(rerankTopN);
        }

        public Builder searchFilters(List<Map<String, Object>> searchFilters) {
            this.options.setSearchFilters(searchFilters);
            return this;
        }

        @Deprecated
        public Builder withSearchFilters(List<Map<String, Object>> searchFilters) {
            return this.searchFilters(searchFilters);
        }

        public DashScopeDocumentRetrieverOptions build() {
            return this.options;
        }
    }
}

