/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.alibaba.cloud.ai.dashscope.rag.util.FileSizeFormatter;

public class DashScopeDocumentCloudReaderConfig {
    public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
    public static final long DEFAULT_MIN_FILE_SIZE = 1L;
    private int maxRetryAttempts = 10;
    private long retryIntervalMillis = 30000L;
    private long initialWaitMillis = 3000L;
    private long maxRetryIntervalMillis = 300000L;
    private boolean useExponentialBackoff = true;
    private double backoffMultiplier = 1.5;
    private long maxFileSize = 0xA00000L;
    private long minFileSize = 1L;
    private boolean enableFileSizeValidation = true;

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public long getInitialWaitMillis() {
        return this.initialWaitMillis;
    }

    public void setInitialWaitMillis(long initialWaitMillis) {
        this.initialWaitMillis = initialWaitMillis;
    }

    public long getRetryIntervalMillis() {
        return this.retryIntervalMillis;
    }

    public void setRetryIntervalMillis(long retryIntervalMillis) {
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public long getMaxRetryIntervalMillis() {
        return this.maxRetryIntervalMillis;
    }

    public void setMaxRetryIntervalMillis(long maxRetryIntervalMillis) {
        this.maxRetryIntervalMillis = maxRetryIntervalMillis;
    }

    public boolean isUseExponentialBackoff() {
        return this.useExponentialBackoff;
    }

    public void setUseExponentialBackoff(boolean useExponentialBackoff) {
        this.useExponentialBackoff = useExponentialBackoff;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public void setBackoffMultiplier(double backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public long getMinFileSize() {
        return this.minFileSize;
    }

    public void setMinFileSize(long minFileSize) {
        this.minFileSize = minFileSize;
    }

    public boolean isEnableFileSizeValidation() {
        return this.enableFileSizeValidation;
    }

    public void setEnableFileSizeValidation(boolean enableFileSizeValidation) {
        this.enableFileSizeValidation = enableFileSizeValidation;
    }

    public DashScopeDocumentCloudReaderConfig withMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
        return this;
    }

    public DashScopeDocumentCloudReaderConfig withRetryIntervalSeconds(long seconds) {
        this.retryIntervalMillis = seconds * 1000L;
        return this;
    }

    public DashScopeDocumentCloudReaderConfig withInitialWaitMillis(long seconds) {
        this.initialWaitMillis = seconds * 1000L;
        return this;
    }

    public DashScopeDocumentCloudReaderConfig withMaxRetryIntervalSeconds(long seconds) {
        this.maxRetryIntervalMillis = seconds * 1000L;
        return this;
    }

    public DashScopeDocumentCloudReaderConfig withMaxFileSizeMB(int megabytes) {
        this.maxFileSize = (long)megabytes * 1024L * 1024L;
        return this;
    }

    public DashScopeDocumentCloudReaderConfig withMinFileSizeBytes(long bytes) {
        this.minFileSize = bytes;
        return this;
    }

    public DashScopeDocumentCloudReaderConfig withoutFileSizeValidation() {
        this.enableFileSizeValidation = false;
        return this;
    }

    public String toString() {
        return "DashScopeDocumentCloudReaderConfig{maxRetryAttempts=" + this.maxRetryAttempts + ", retryIntervalMillis=" + this.retryIntervalMillis + ", initialWaitMillis=" + this.initialWaitMillis + ", maxRetryIntervalMillis=" + this.maxRetryIntervalMillis + ", useExponentialBackoff=" + this.useExponentialBackoff + ", backoffMultiplier=" + this.backoffMultiplier + ", maxFileSize=" + FileSizeFormatter.format(this.maxFileSize) + ", minFileSize=" + FileSizeFormatter.format(this.minFileSize) + ", enableFileSizeValidation=" + this.enableFileSizeValidation + "}";
    }
}

