/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.common.ErrorCodeEnum;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentCloudReaderConfig;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentCloudReaderOptions;
import com.alibaba.cloud.ai.dashscope.rag.context.DocumentProcessContext;
import com.alibaba.cloud.ai.dashscope.rag.exception.DashScopeDocumentException;
import com.alibaba.cloud.ai.dashscope.rag.exception.DocumentParseTimeoutException;
import com.alibaba.cloud.ai.dashscope.rag.handler.DefaultFileStatusHandler;
import com.alibaba.cloud.ai.dashscope.rag.handler.FileStatusHandler;
import com.alibaba.cloud.ai.dashscope.rag.handler.FileStatusResult;
import com.alibaba.cloud.ai.dashscope.rag.validation.FileValidator;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentReader;
import org.springframework.http.ResponseEntity;

public class DashScopeDocumentCloudReader
implements DocumentReader {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeDocumentCloudReader.class);
    private final DashScopeApi dashScopeApi;
    private final DashScopeDocumentCloudReaderOptions readerConfig;
    private final DashScopeDocumentCloudReaderConfig clientConfig;
    private final File file;
    private final FileStatusHandler fileHandler;
    private final FileValidator fileValidator;

    public DashScopeDocumentCloudReader(String filePath, DashScopeApi dashScopeApi, DashScopeDocumentCloudReaderOptions options) {
        this(filePath, dashScopeApi, options, new DashScopeDocumentCloudReaderConfig());
    }

    public DashScopeDocumentCloudReader(String filePath, DashScopeApi dashScopeApi, DashScopeDocumentCloudReaderOptions readerConfig, DashScopeDocumentCloudReaderConfig clientConfig) {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new IllegalArgumentException("File path must not be null or empty");
        }
        if (dashScopeApi == null) {
            throw new IllegalArgumentException("DashScopeApi must not be null");
        }
        this.file = new File(filePath);
        this.dashScopeApi = dashScopeApi;
        this.readerConfig = readerConfig != null ? readerConfig : new DashScopeDocumentCloudReaderOptions();
        this.clientConfig = clientConfig != null ? clientConfig : new DashScopeDocumentCloudReaderConfig();
        this.fileHandler = new DefaultFileStatusHandler();
        this.fileValidator = new FileValidator(this.clientConfig);
        this.validateFile();
    }

    private void validateFile() {
        this.fileValidator.validate(this.file);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Document> get() {
        List<Document> list;
        logger.info("Starting document processing for file: {}", (Object)this.file.getName());
        DocumentProcessContext context = new DocumentProcessContext();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            context.setFileMD5(DigestUtils.md5Hex((InputStream)fileInputStream));
            logger.debug("File MD5 calculated: {} for file: {}", (Object)context.getFileMD5(), (Object)this.file.getName());
            context.setFileId(this.uploadFile(context.getFileMD5()));
            logger.info("File uploaded successfully. FileId: {}, FileName: {}", (Object)context.getFileId(), (Object)this.file.getName());
            this.pollAndWaitForCompletion(context);
            String parseResult = this.downloadParseResult(context.getFileId());
            Document document = this.toDocument(context.getFileId(), parseResult);
            logger.info("Document processing completed successfully. FileId: {}, FileName: {}", (Object)context.getFileId(), (Object)this.file.getName());
            list = Collections.singletonList(document);
        }
        catch (DashScopeDocumentException e) {
            try {
                e.withFilePath(this.file.getAbsolutePath());
                if (context.getFileId() != null) {
                    e.withFileId(context.getFileId());
                }
                logger.error("Document processing failed: {}", (Object)e.getMessage());
                throw e;
                catch (IOException e2) {
                    logger.error("IO error while processing file: {}", (Object)this.file.getName(), (Object)e2);
                    throw new DashScopeDocumentException(ErrorCodeEnum.READER_PARSE_FILE_ERROR);
                }
                catch (InterruptedException e3) {
                    Thread.currentThread().interrupt();
                    logger.error("Document processing interrupted for file: {}", (Object)this.file.getName(), (Object)e3);
                    throw new DashScopeDocumentException(ErrorCodeEnum.READER_PARSE_FILE_ERROR);
                }
                catch (Exception e4) {
                    logger.error("Unexpected error processing file: {}, FileId: {}", new Object[]{this.file.getName(), context.getFileId(), e4});
                    throw new DashScopeDocumentException(ErrorCodeEnum.READER_PARSE_FILE_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        this.closeQuietly(fileInputStream);
        return list;
    }

    private String uploadFile(String fileMD5) {
        DashScopeApiSpec.UploadRequest uploadRequest = new DashScopeApiSpec.UploadRequest(this.readerConfig.getCategoryId(), this.file.getName(), this.file.length(), fileMD5);
        String fileId = this.dashScopeApi.upload(this.file, uploadRequest);
        if (fileId == null || fileId.trim().isEmpty()) {
            logger.error("Upload returned empty fileId for file: {}", (Object)this.file.getName());
            throw new DashScopeDocumentException(ErrorCodeEnum.READER_PARSE_FILE_ERROR);
        }
        return fileId;
    }

    private void pollAndWaitForCompletion(DocumentProcessContext context) throws InterruptedException {
        int tryCount = 0;
        long startTime = System.currentTimeMillis();
        int maxRetryCount = this.getMaxRetryCount();
        long initialWaitMillis = this.clientConfig.getInitialWaitMillis();
        if (initialWaitMillis > 0L) {
            logger.debug("Initial wait {}ms before first status check", (Object)initialWaitMillis);
            Thread.sleep(initialWaitMillis);
        }
        while (tryCount < maxRetryCount) {
            ResponseEntity<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.QueryFileResponseData>> response = this.queryFileStatus(context.getFileId());
            if (response == null || response.getBody() == null) {
                logger.warn("Received null response for fileId: {}, attempt: {}/{}", new Object[]{context.getFileId(), tryCount + 1, maxRetryCount});
                this.waitBeforeNextRetry(tryCount);
                ++tryCount;
                continue;
            }
            DashScopeApiSpec.QueryFileResponseData data = (DashScopeApiSpec.QueryFileResponseData)((DashScopeApiSpec.CommonResponse)response.getBody()).data();
            if (data == null) {
                logger.warn("Received null data for fileId: {}, attempt: {}/{}", new Object[]{context.getFileId(), tryCount + 1, maxRetryCount});
                this.waitBeforeNextRetry(tryCount);
                ++tryCount;
                continue;
            }
            String fileStatus = data.status();
            logger.debug("File status check: FileId={}, Status={}, Attempt={}/{}", new Object[]{context.getFileId(), fileStatus, tryCount + 1, maxRetryCount});
            FileStatusResult result = this.fileHandler.handle(context, response);
            if (result.isCompleted()) {
                if (result.isSuccess()) {
                    long elapsed = System.currentTimeMillis() - startTime;
                    logger.info("File parsing succeeded: FileId={}, Attempts={}, ElapsedTime={}ms", new Object[]{context.getFileId(), tryCount + 1, elapsed});
                    return;
                }
                logger.error("File parsing failed: FileId={}, ErrorMessage={}", (Object)context.getFileId(), (Object)result.getErrorMessage());
                throw new DashScopeException(ErrorCodeEnum.READER_PARSE_FILE_ERROR);
            }
            this.waitBeforeNextRetry(tryCount);
            ++tryCount;
        }
        long totalElapsed = System.currentTimeMillis() - startTime;
        logger.error("File parsing timed out: FileId={}, TotalElapsedTime={}ms, ErrorMessage={}", new Object[]{context.getFileId(), totalElapsed, String.format("File parsing timeout after %d attempts (%d ms) for fileId: %s, fileName: %s", tryCount, totalElapsed, context.getFileId(), this.file.getName())});
        throw new DocumentParseTimeoutException(String.format("File parsing timeout for fileId: %s, fileName: %s", context.getFileId(), this.file.getName()), tryCount, totalElapsed).withFileId(context.getFileId()).withFilePath(context.getFileMD5());
    }

    private ResponseEntity<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.QueryFileResponseData>> queryFileStatus(String fileId) {
        return this.dashScopeApi.queryFileInfo(this.readerConfig.getCategoryId(), new DashScopeApiSpec.UploadRequest.QueryFileRequest(fileId));
    }

    private String downloadParseResult(String fileId) {
        String parseResult = this.dashScopeApi.getFileParseResult(this.readerConfig.getCategoryId(), new DashScopeApiSpec.UploadRequest.QueryFileRequest(fileId));
        if (parseResult == null || parseResult.trim().isEmpty()) {
            logger.warn("Downloaded empty parse result for fileId: {}", (Object)fileId);
            return "";
        }
        return parseResult;
    }

    private void waitBeforeNextRetry(int attemptCount) throws InterruptedException {
        long delay = this.calculateRetryDelay(attemptCount);
        logger.debug("Waiting {}ms before next attempt", (Object)delay);
        Thread.sleep(delay);
    }

    private long calculateRetryDelay(int attemptCount) {
        if (this.clientConfig.isUseExponentialBackoff()) {
            long baseDelay = this.clientConfig.getRetryIntervalMillis();
            double multiplier = this.clientConfig.getBackoffMultiplier();
            long maxDelay = this.clientConfig.getMaxRetryIntervalMillis();
            long delay = (long)((double)baseDelay * Math.pow(multiplier, attemptCount));
            return Math.min(delay, maxDelay);
        }
        return this.clientConfig.getRetryIntervalMillis();
    }

    private int getMaxRetryCount() {
        return this.clientConfig.getMaxRetryAttempts() > 0 ? this.clientConfig.getMaxRetryAttempts() : 10;
    }

    private Document toDocument(String fileId, String parseResultText) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("parse_fmt_type", "DASHSCOPE_DOCMIND");
        metaData.put("file_id", fileId);
        metaData.put("file_name", this.file.getName());
        metaData.put("file_size", this.file.length());
        return new Document(fileId, parseResultText, metaData);
    }

    private void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.debug("Error closing resource: {}", (Object)e.getMessage());
            }
        }
    }
}

