/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.chat;

import com.alibaba.cloud.ai.dashscope.api.DashScopeResponseFormat;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonIgnore
    private Boolean stream;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="stop")
    private List<Object> stop;
    @JsonProperty(value="enable_search")
    private Boolean enableSearch = false;
    @JsonProperty(value="response_format")
    private DashScopeResponseFormat responseFormat;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="incremental_output")
    private Boolean incrementalOutput = true;
    @JsonProperty(value="repetition_penalty")
    private Double repetitionPenalty;
    @JsonProperty(value="tools")
    private List<DashScopeApiSpec.FunctionTool> tools;
    @JsonProperty(value="search_options")
    private DashScopeApiSpec.SearchOptions searchOptions;
    @JsonProperty(value="parallel_tool_calls")
    private Boolean parallelToolCalls;
    @JsonIgnore
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    @JsonProperty(value="vl_high_resolution_images")
    private Boolean vlHighResolutionImages;
    @JsonProperty(value="enable_thinking")
    private Boolean enableThinking = false;
    @JsonProperty(value="thinking_budget")
    private Integer thinkingBudget;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonProperty(value="multi_model")
    private Boolean multiModel = false;
    private Boolean vlEnableImageHwOutput = false;
    @JsonProperty(value="audio")
    private Object audio = null;
    @JsonProperty(value="stream_options")
    private Object streamOptions = null;
    @JsonProperty(value="asr_options")
    private Object asrOptions;
    @JsonProperty(value="max_input_tokens")
    private Integer maxInputTokens;
    @JsonProperty(value="modalities")
    private List<String> modalities;
    @JsonProperty(value="ocr_options")
    private DashScopeApiSpec.OCROption ocrOptions;
    @JsonProperty(value="top_logprobs")
    private Integer topLogProbs;
    @JsonProperty(value="logprobs")
    private Boolean logprobs;
    @JsonProperty(value="translation_options")
    private DashScopeApiSpec.TranslationOptions translationOptions;
    @JsonProperty(value="output_format")
    private String outputFormat;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonProperty(value="extra_body")
    private Map<String, Object> extraBody;

    public DashScopeApiSpec.TranslationOptions getTranslationOptions() {
        return this.translationOptions;
    }

    public void setTranslationOptions(DashScopeApiSpec.TranslationOptions translationOptions) {
        this.translationOptions = translationOptions;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public Integer getTopLogProbs() {
        return this.topLogProbs;
    }

    public void setTopLogProbs(Integer topLogProbs) {
        this.topLogProbs = topLogProbs;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public DashScopeApiSpec.OCROption getOcrOptions() {
        return this.ocrOptions;
    }

    public void setOcrOptions(DashScopeApiSpec.OCROption ocrOptions) {
        this.ocrOptions = ocrOptions;
    }

    public Boolean getVlEnableImageHwOutput() {
        return this.vlEnableImageHwOutput;
    }

    public void setVlEnableImageHwOutput(Boolean vlEnableImageHwOutput) {
        this.vlEnableImageHwOutput = vlEnableImageHwOutput;
    }

    public Object getAudio() {
        return this.audio;
    }

    public void setAudio(Object audio) {
        this.audio = audio;
    }

    public Object getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(Object streamOptions) {
        this.streamOptions = streamOptions;
    }

    public Object getAsrOptions() {
        return this.asrOptions;
    }

    public void setAsrOptions(Object asrOptions) {
        this.asrOptions = asrOptions;
    }

    public Integer getMaxInputTokens() {
        return this.maxInputTokens;
    }

    public void setMaxInputTokens(Integer maxInputTokens) {
        this.maxInputTokens = maxInputTokens;
    }

    public List<String> getModalities() {
        return this.modalities;
    }

    public void setModalities(List<String> modalities) {
        this.modalities = modalities;
    }

    public String getModel() {
        return this.model;
    }

    public Double getFrequencyPenalty() {
        return null;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Double getPresencePenalty() {
        return null;
    }

    public List<String> getStopSequences() {
        return null;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setSearchOptions(DashScopeApiSpec.SearchOptions searchOptions) {
        this.searchOptions = searchOptions;
    }

    public DashScopeApiSpec.SearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Double getTopP() {
        return this.topP;
    }

    public ChatOptions copy() {
        return DashScopeChatOptions.fromOptions(this);
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public List<Object> getStop() {
        return this.stop;
    }

    public void setStop(List<Object> stop) {
        this.stop = stop;
    }

    public DashScopeResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public Integer getThinkingBudget() {
        return this.thinkingBudget;
    }

    public void setThinkingBudget(Integer thinkingBudget) {
        this.thinkingBudget = thinkingBudget;
    }

    public void setResponseFormat(DashScopeResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Boolean getEnableSearch() {
        return this.enableSearch;
    }

    public void setEnableSearch(Boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public Double getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public void setRepetitionPenalty(Double repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public List<DashScopeApiSpec.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<DashScopeApiSpec.FunctionTool> tools) {
        this.tools = tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Boolean getIncrementalOutput() {
        return this.incrementalOutput;
    }

    public void setIncrementalOutput(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public Boolean getVlHighResolutionImages() {
        return this.vlHighResolutionImages;
    }

    public void setVlHighResolutionImages(Boolean vlHighResolutionImages) {
        this.vlHighResolutionImages = vlHighResolutionImages;
    }

    public Boolean getEnableThinking() {
        return this.enableThinking;
    }

    public void setEnableThinking(Boolean enableThinking) {
        this.enableThinking = enableThinking;
    }

    public Boolean getMultiModel() {
        return this.multiModel;
    }

    public void setMultiModel(Boolean multiModel) {
        this.multiModel = multiModel;
    }

    public Map<String, Object> getExtraBody() {
        return this.extraBody;
    }

    public void setExtraBody(Map<String, Object> extraBody) {
        this.extraBody = extraBody;
    }

    public static DashScopeChatOptionsBuilder builder() {
        return new DashScopeChatOptionsBuilder();
    }

    public static DashScopeChatOptions fromOptions(DashScopeChatOptions fromOptions) {
        return DashScopeChatOptions.builder().model(fromOptions.model).temperature(fromOptions.temperature).maxToken(fromOptions.maxTokens).topP(fromOptions.topP).topK(fromOptions.topK).seed(fromOptions.seed).stop(fromOptions.stop).responseFormat(fromOptions.responseFormat).stream(fromOptions.stream).enableSearch(fromOptions.enableSearch).incrementalOutput(fromOptions.incrementalOutput).toolCallbacks(fromOptions.toolCallbacks).toolNames(fromOptions.toolNames).internalToolExecutionEnabled(fromOptions.internalToolExecutionEnabled).repetitionPenalty(fromOptions.repetitionPenalty).tools(fromOptions.tools).toolContext(fromOptions.toolContext).multiModel(fromOptions.multiModel).vlHighResolutionImages(fromOptions.vlHighResolutionImages).enableThinking(fromOptions.enableThinking).thinkingBudget(fromOptions.thinkingBudget).parallelToolCalls(fromOptions.parallelToolCalls).searchOptions(fromOptions.searchOptions).httpHeaders(fromOptions.httpHeaders).modalities(fromOptions.modalities).audio(fromOptions.audio).streamOptions(fromOptions.streamOptions).extraBody(fromOptions.extraBody).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashScopeChatOptions that = (DashScopeChatOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.stream, that.stream) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.seed, that.seed) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.stop, that.stop) && Objects.equals(this.enableSearch, that.enableSearch) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.incrementalOutput, that.incrementalOutput) && Objects.equals(this.repetitionPenalty, that.repetitionPenalty) && Objects.equals(this.tools, that.tools) && Objects.equals(this.toolChoice, that.toolChoice) && Objects.equals(this.vlHighResolutionImages, that.vlHighResolutionImages) && Objects.equals(this.enableThinking, that.enableThinking) && Objects.equals(this.thinkingBudget, that.thinkingBudget) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.multiModel, that.multiModel) && Objects.equals(this.searchOptions, that.searchOptions) && Objects.equals(this.parallelToolCalls, that.parallelToolCalls) && Objects.equals(this.httpHeaders, that.httpHeaders) && Objects.equals(this.toolContext, that.toolContext) && Objects.equals(this.modalities, that.modalities) && Objects.equals(this.audio, that.audio) && Objects.equals(this.streamOptions, that.streamOptions) && Objects.equals(this.extraBody, that.extraBody);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.stream, this.temperature, this.seed, this.topP, this.topK, this.stop, this.enableSearch, this.responseFormat, this.incrementalOutput, this.repetitionPenalty, this.tools, this.toolChoice, this.vlHighResolutionImages, this.enableThinking, this.thinkingBudget, this.toolCallbacks, this.toolNames, this.internalToolExecutionEnabled, this.multiModel, this.searchOptions, this.parallelToolCalls, this.httpHeaders, this.toolContext, this.modalities, this.audio, this.streamOptions, this.extraBody);
    }

    public String toString() {
        return "DashScopeChatOptions: " + ModelOptionsUtils.toJsonString((Object)this);
    }

    public static class DashScopeChatOptionsBuilder {
        private final DashScopeChatOptions options = new DashScopeChatOptions();

        public DashScopeChatOptionsBuilder model(String model) {
            this.options.model = model;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withModel(String model) {
            return this.model(model);
        }

        public DashScopeChatOptionsBuilder searchOptions(DashScopeApiSpec.SearchOptions searchOptions) {
            this.options.searchOptions = searchOptions;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withSearchOptions(DashScopeApiSpec.SearchOptions searchOptions) {
            return this.searchOptions(searchOptions);
        }

        public DashScopeChatOptionsBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.options.parallelToolCalls = parallelToolCalls;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withParallelToolCalls(Boolean parallelToolCalls) {
            return this.parallelToolCalls(parallelToolCalls);
        }

        public DashScopeChatOptionsBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.options.httpHeaders = httpHeaders;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withHttpHeaders(Map<String, String> httpHeaders) {
            return this.httpHeaders(httpHeaders);
        }

        public DashScopeChatOptionsBuilder maxToken(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withMaxToken(Integer maxTokens) {
            return this.maxToken(maxTokens);
        }

        public DashScopeChatOptionsBuilder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withTemperature(Double temperature) {
            return this.temperature(temperature);
        }

        public DashScopeChatOptionsBuilder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withTopP(Double topP) {
            return this.topP(topP);
        }

        public DashScopeChatOptionsBuilder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withTopK(Integer topK) {
            return this.topK(topK);
        }

        public DashScopeChatOptionsBuilder stop(List<Object> stop) {
            this.options.stop = stop;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withStop(List<Object> stop) {
            return this.stop(stop);
        }

        public DashScopeChatOptionsBuilder responseFormat(DashScopeResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withResponseFormat(DashScopeResponseFormat responseFormat) {
            return this.responseFormat(responseFormat);
        }

        public DashScopeChatOptionsBuilder enableSearch(Boolean enableSearch) {
            this.options.enableSearch = enableSearch;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withEnableSearch(Boolean enableSearch) {
            return this.enableSearch(enableSearch);
        }

        public DashScopeChatOptionsBuilder repetitionPenalty(Double repetitionPenalty) {
            this.options.repetitionPenalty = repetitionPenalty;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withRepetitionPenalty(Double repetitionPenalty) {
            return this.repetitionPenalty(repetitionPenalty);
        }

        public DashScopeChatOptionsBuilder tools(List<DashScopeApiSpec.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withTools(List<DashScopeApiSpec.FunctionTool> tools) {
            return this.tools(tools);
        }

        public DashScopeChatOptionsBuilder toolChoice(Object toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withToolChoice(Object toolChoice) {
            return this.toolChoice(toolChoice);
        }

        public DashScopeChatOptionsBuilder stream(Boolean stream) {
            this.options.stream = stream;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withStream(Boolean stream) {
            return this.stream(stream);
        }

        public DashScopeChatOptionsBuilder toolCallbacks(List<ToolCallback> toolCallbacks) {
            Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.options.toolCallbacks = toolCallbacks;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withToolCallbacks(List<ToolCallback> toolCallbacks) {
            return this.toolCallbacks(toolCallbacks);
        }

        public DashScopeChatOptionsBuilder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
            toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
            this.options.toolNames = toolNames;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withToolNames(Set<String> toolNames) {
            return this.toolNames(toolNames);
        }

        public DashScopeChatOptionsBuilder toolName(String toolName) {
            Assert.hasText((String)toolName, (String)"Tool name must not be empty");
            this.options.toolNames.add(toolName);
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withToolName(String toolName) {
            return this.toolName(toolName);
        }

        public DashScopeChatOptionsBuilder internalToolExecutionEnabled(Boolean internalToolExecutionEnabled) {
            this.options.internalToolExecutionEnabled = internalToolExecutionEnabled;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withInternalToolExecutionEnabled(Boolean internalToolExecutionEnabled) {
            return this.internalToolExecutionEnabled(internalToolExecutionEnabled);
        }

        public DashScopeChatOptionsBuilder seed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withSeed(Integer seed) {
            return this.seed(seed);
        }

        public DashScopeChatOptionsBuilder incrementalOutput(Boolean incrementalOutput) {
            this.options.incrementalOutput = incrementalOutput;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withIncrementalOutput(Boolean incrementalOutput) {
            return this.incrementalOutput(incrementalOutput);
        }

        public DashScopeChatOptionsBuilder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withToolContext(Map<String, Object> toolContext) {
            return this.toolContext(toolContext);
        }

        public DashScopeChatOptionsBuilder vlHighResolutionImages(Boolean vlHighResolutionImages) {
            this.options.vlHighResolutionImages = vlHighResolutionImages;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withVlHighResolutionImages(Boolean vlHighResolutionImages) {
            return this.vlHighResolutionImages(vlHighResolutionImages);
        }

        public DashScopeChatOptionsBuilder enableThinking(Boolean enableThinking) {
            this.options.enableThinking = enableThinking;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withEnableThinking(Boolean enableThinking) {
            return this.enableThinking(enableThinking);
        }

        public DashScopeChatOptionsBuilder multiModel(Boolean multiModel) {
            this.options.multiModel = multiModel;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withMultiModel(Boolean multiModel) {
            return this.multiModel(multiModel);
        }

        public DashScopeChatOptionsBuilder thinkingBudget(Integer thinkingBudget) {
            this.options.thinkingBudget = thinkingBudget;
            return this;
        }

        @Deprecated
        public DashScopeChatOptionsBuilder withThinkingBudget(Integer thinkingBudget) {
            return this.thinkingBudget(thinkingBudget);
        }

        public DashScopeChatOptionsBuilder modalities(List<String> modalities) {
            this.options.modalities = modalities;
            return this;
        }

        public DashScopeChatOptionsBuilder audio(Object audio) {
            this.options.audio = audio;
            return this;
        }

        public DashScopeChatOptionsBuilder streamOptions(Object streamOptions) {
            this.options.streamOptions = streamOptions;
            return this;
        }

        public DashScopeChatOptionsBuilder extraBody(Map<String, Object> extraBody) {
            this.options.extraBody = extraBody;
            return this;
        }

        public DashScopeChatOptions build() {
            return this.options;
        }
    }
}

