/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.chat;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.cloud.ai.dashscope.chat.MessageFormat;
import com.alibaba.cloud.ai.dashscope.chat.observation.DashScopeChatModelObservationConvention;
import com.alibaba.cloud.ai.dashscope.common.DashScopeApiConstants;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import com.alibaba.cloud.ai.tool.observation.inner.ToolCallReactiveContextHolder;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.support.UsageCalculator;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DashScopeChatModel
implements ChatModel {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeChatModel.class);
    public static final String DEFAULT_MODEL_NAME = DashScopeApi.DEFAULT_CHAT_MODEL;
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DashScopeChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private DashScopeChatOptions defaultOptions;
    private final DashScopeApi dashscopeApi;
    public final RetryTemplate retryTemplate;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public DashScopeChatModel(DashScopeApi dashscopeApi, DashScopeChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(dashscopeApi, defaultOptions, toolCallingManager, retryTemplate, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public DashScopeChatModel(DashScopeApi dashscopeApi, DashScopeChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)dashscopeApi, (String)"dashscopeApi cannot be null");
        Assert.notNull((Object)defaultOptions, (String)"defaultOptions cannot be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager cannot be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"toolExecutionEligibilityPredicate cannot be null");
        this.dashscopeApi = dashscopeApi;
        this.defaultOptions = defaultOptions;
        this.toolCallingManager = toolCallingManager;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
    }

    public ChatResponse call(Prompt prompt) {
        Assert.notNull((Object)prompt, (String)"Prompt must not be null");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)prompt.getInstructions()) ? 1 : 0) != 0, (String)"Prompt messages must not be empty");
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    public ChatOptions getDefaultOptions() {
        return DashScopeChatOptions.fromOptions(this.defaultOptions);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        DashScopeApiSpec.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(DashScopeApiConstants.PROVIDER_NAME).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.dashscopeApi.chatCompletionEntity(request, this.getAdditionalHttpHeaders(prompt)));
            DashScopeApiSpec.ChatCompletion completionResponse = (DashScopeApiSpec.ChatCompletion)completionEntity.getBody();
            ChatResponse chatResponse = this.toChatResponse(completionResponse, previousChatResponse, request, null);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Assert.notNull((Object)prompt, (String)"Prompt must not be null");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)prompt.getInstructions()) ? 1 : 0) != 0, (String)"Prompt messages must not be empty");
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            DashScopeApiSpec.ChatCompletionRequest request = this.createRequest(prompt, true);
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.dashscopeApi.chatCompletionStream(request, this.getAdditionalHttpHeaders(prompt)));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(DashScopeApiConstants.PROVIDER_NAME).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::chunkToChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> this.toChatResponse((DashScopeApiSpec.ChatCompletion)chatCompletion2, previousChatResponse, request, roleMap)));
            Flux flux = chatResponse.flatMap(response -> {
                if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
                    return Flux.deferContextual(ctx -> {
                        ToolExecutionResult toolExecutionResult;
                        try {
                            ToolCallReactiveContextHolder.setContext(ctx);
                            toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
                        }
                        finally {
                            ToolCallReactiveContextHolder.clearContext();
                        }
                        if (toolExecutionResult.returnDirect()) {
                            return Flux.just((Object)ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                        }
                        return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), (ChatResponse)response);
                    }).subscribeOn(Schedulers.boundedElastic());
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private static String finishReasonToMetadataValue(DashScopeApiSpec.ChatCompletionFinishReason finishReason) {
        if (finishReason == null || finishReason == DashScopeApiSpec.ChatCompletionFinishReason.NULL) {
            return "";
        }
        return finishReason.name();
    }

    private ChatResponse toChatResponse(DashScopeApiSpec.ChatCompletion chatCompletion, ChatResponse previousChatResponse, DashScopeApiSpec.ChatCompletionRequest request, ConcurrentHashMap<String, String> roleMap) {
        if (chatCompletion == null) {
            logger.warn("Null chat completion returned");
            return new ChatResponse(List.of());
        }
        List<DashScopeApiSpec.ChatCompletionOutput.Choice> choices = chatCompletion.output().choices();
        if (choices == null) {
            logger.warn("No choices returned");
            return new ChatResponse(List.of());
        }
        DashScopeApiSpec.SearchInfo searchInfo = chatCompletion.output().searchInfo();
        ConcurrentHashMap finalRoleMap = roleMap == null ? new ConcurrentHashMap() : roleMap;
        List<Generation> generations = choices.stream().map(choice -> {
            if (choice.message().role() != null) {
                finalRoleMap.putIfAbsent(chatCompletion.requestId(), choice.message().role().name());
            }
            Map<String, Object> metadata = Map.of("id", chatCompletion.requestId(), "role", finalRoleMap.getOrDefault(chatCompletion.requestId(), ""), "finishReason", DashScopeChatModel.finishReasonToMetadataValue(choice.finishReason()), "reasoningContent", StringUtils.hasText((String)choice.message().reasoningContent()) ? choice.message().reasoningContent() : "", "search_info", Objects.isNull(searchInfo) ? "" : searchInfo);
            return DashScopeChatModel.buildGeneration(choice, metadata, request);
        }).toList();
        DashScopeApiSpec.TokenUsage usage = chatCompletion.usage();
        EmptyUsage currentChatResponseUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
        Usage accumulatedUsage = UsageCalculator.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
        return new ChatResponse(generations, this.from(chatCompletion, accumulatedUsage));
    }

    public DashScopeChatOptions getDashScopeChatOptions() {
        return this.defaultOptions;
    }

    public void setDashScopeChatOptions(DashScopeChatOptions options) {
        this.defaultOptions = options;
    }

    private static Generation buildGeneration(DashScopeApiSpec.ChatCompletionOutput.Choice choice, Map<String, Object> metadata, DashScopeApiSpec.ChatCompletionRequest request) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : choice.message().toolCalls().stream().filter(toolCall -> {
            if (toolCall.function() == null) {
                logger.warn("Filtering out toolCall with null function: {}", toolCall);
                return false;
            }
            if (toolCall.function().name() == null) {
                logger.warn("Filtering out toolCall with null function name: {}", toolCall);
                return false;
            }
            return true;
        }).map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), "function", toolCall.function().name(), toolCall.function().arguments())).toList();
        String finishReason = DashScopeChatModel.finishReasonToMetadataValue(choice.finishReason());
        ChatGenerationMetadata.Builder generationMetadataBuilder = ChatGenerationMetadata.builder().finishReason(finishReason);
        AssistantMessage assistantMessage = AssistantMessage.builder().content(choice.message().content()).properties(metadata).toolCalls(toolCalls).build();
        return new Generation(assistantMessage, generationMetadataBuilder.build());
    }

    private DashScopeApiSpec.ChatCompletion chunkToChatCompletion(DashScopeApiSpec.ChatCompletionChunk chunk) {
        if (Objects.isNull(chunk) || Objects.isNull(chunk.output())) {
            throw new RuntimeException("LLM response chunk is null.");
        }
        return new DashScopeApiSpec.ChatCompletion(chunk.requestId(), new DashScopeApiSpec.ChatCompletionOutput(chunk.output().text(), chunk.output().choices(), chunk.output().searchInfo()), chunk.usage());
    }

    private ChatResponseMetadata from(DashScopeApiSpec.ChatCompletion result, Usage usage) {
        Assert.notNull((Object)result, (String)"DashScopeAi ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.requestId()).usage(usage).model("").build();
    }

    private DefaultUsage getDefaultUsage(DashScopeApiSpec.TokenUsage usage) {
        if (usage == null) {
            return new DefaultUsage(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        }
        int promptTokens = usage.inputTokens() != null ? usage.inputTokens() : 0;
        int generationTokens = usage.outputTokens() != null ? usage.outputTokens() : 0;
        int totalTokens = usage.totalTokens() != null ? usage.totalTokens() : 0;
        return new DefaultUsage(Integer.valueOf(promptTokens), Integer.valueOf(generationTokens), Integer.valueOf(totalTokens));
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        DashScopeChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (DashScopeChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, DashScopeChatOptions.class);
            } else {
                runtimeOptions = (DashScopeChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, DashScopeChatOptions.class);
            }
        }
        DashScopeChatOptions requestOptions = (DashScopeChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, DashScopeChatOptions.class);
        if (runtimeOptions != null && !CollectionUtils.isEmpty(runtimeOptions.getHttpHeaders())) {
            requestOptions.setHttpHeaders(runtimeOptions.getHttpHeaders());
        } else {
            requestOptions.setHttpHeaders(this.defaultOptions.getHttpHeaders());
        }
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
            requestOptions.setExtraBody(this.mergeExtraBody(runtimeOptions.getExtraBody(), this.defaultOptions.getExtraBody()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
            requestOptions.setExtraBody(this.defaultOptions.getExtraBody());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    DashScopeApiSpec.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<DashScopeApiSpec.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                UserMessage userMessage;
                Object content = message.getText();
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    content = this.convertMediaContent(userMessage);
                }
                return List.of(new DashScopeApiSpec.ChatCompletionMessage(content, DashScopeApiSpec.ChatCompletionMessage.Role.valueOf(message.getMessageType().name())));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<DashScopeApiSpec.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        DashScopeApiSpec.ChatCompletionMessage.ChatCompletionFunction function = new DashScopeApiSpec.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new DashScopeApiSpec.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function, null);
                    }).toList();
                }
                Boolean partial = null;
                if (assistantMessage.getMetadata() != null) {
                    Object partialValue = assistantMessage.getMetadata().get("partial");
                    if (partialValue instanceof Boolean) {
                        partial = (Boolean)partialValue;
                    } else if (partialValue instanceof String) {
                        partial = Boolean.parseBoolean((String)partialValue);
                    }
                }
                return List.of(new DashScopeApiSpec.ChatCompletionMessage(assistantMessage.getText(), DashScopeApiSpec.ChatCompletionMessage.Role.ASSISTANT, null, null, toolCalls, null, partial, null, null, null));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> {
                    Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id");
                    Assert.isTrue((response.name() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have a name");
                });
                return toolMessage.getResponses().stream().map(tr -> new DashScopeApiSpec.ChatCompletionMessage(tr.responseData(), DashScopeApiSpec.ChatCompletionMessage.Role.TOOL, tr.name(), tr.id(), null, null, null, null, null, null)).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + message.getMessageType());
        }).flatMap(Collection::stream).toList();
        DashScopeChatOptions requestOptions = (DashScopeChatOptions)prompt.getOptions();
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            requestOptions.setTools(this.getFunctionTools(toolDefinitions));
        }
        boolean multiModel = requestOptions.getMultiModel();
        return new DashScopeApiSpec.ChatCompletionRequest(requestOptions.getModel(), new DashScopeApiSpec.ChatCompletionRequestInput(chatCompletionMessages), this.toDashScopeRequestParameter(requestOptions, stream), stream, multiModel);
    }

    private MultiValueMap<String, String> getAdditionalHttpHeaders(Prompt prompt) {
        ChatOptions chatOptions;
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultOptions.getHttpHeaders());
        if (prompt.getOptions() != null && (chatOptions = prompt.getOptions()) instanceof DashScopeChatOptions) {
            DashScopeChatOptions chatOptions2 = (DashScopeChatOptions)chatOptions;
            headers.putAll(chatOptions2.getHttpHeaders());
        }
        return CollectionUtils.toMultiValueMap(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.of((String)e.getValue()))));
    }

    private List<DashScopeApiSpec.ChatCompletionMessage.MediaContent> convertMediaContent(UserMessage message) {
        MessageFormat format = MessageFormat.IMAGE;
        Object v = message.getMetadata().get("messageFormat");
        if (v instanceof MessageFormat) {
            MessageFormat messageFormat;
            format = messageFormat = (MessageFormat)((Object)v);
        }
        ArrayList<DashScopeApiSpec.ChatCompletionMessage.MediaContent> contentList = new ArrayList<DashScopeApiSpec.ChatCompletionMessage.MediaContent>();
        if (format == MessageFormat.VIDEO) {
            List<String> mediaList = message.getMedia().stream().map(media -> this.fromMediaData(media.getMimeType(), media.getData())).toList();
            contentList.add(new DashScopeApiSpec.ChatCompletionMessage.MediaContent("video", null, null, mediaList));
            DashScopeApiSpec.ChatCompletionMessage.MediaContent mediaContent = new DashScopeApiSpec.ChatCompletionMessage.MediaContent(message.getText());
            contentList.add(mediaContent);
        } else if (format == MessageFormat.AUDIO) {
            contentList.addAll(message.getMedia().stream().map(media -> new DashScopeApiSpec.ChatCompletionMessage.MediaContent("audio", null, null, null, this.fromMediaData(media.getMimeType(), media.getData()))).toList());
            mediaContent = new DashScopeApiSpec.ChatCompletionMessage.MediaContent(message.getText());
            contentList.add(mediaContent);
        } else {
            contentList.addAll(message.getMedia().stream().map(media -> new DashScopeApiSpec.ChatCompletionMessage.MediaContent("image", null, this.fromMediaData(media.getMimeType(), media.getData()), null)).toList());
            mediaContent = new DashScopeApiSpec.ChatCompletionMessage.MediaContent(message.getText());
            contentList.add(mediaContent);
        }
        return contentList;
    }

    private String fromMediaData(MimeType mimeType, Object mediaContentData) {
        if (mediaContentData instanceof byte[]) {
            byte[] bytes = (byte[])mediaContentData;
            return String.format("data:%s;base64,%s", mimeType.toString(), Base64.getEncoder().encodeToString(bytes));
        }
        if (mediaContentData instanceof String) {
            String text = (String)mediaContentData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaContentData.getClass().getSimpleName());
    }

    private List<DashScopeApiSpec.FunctionTool> getFunctionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            DashScopeApiSpec.FunctionTool.Function function = new DashScopeApiSpec.FunctionTool.Function(toolDefinition.description(), toolDefinition.name(), toolDefinition.inputSchema());
            return new DashScopeApiSpec.FunctionTool(function);
        }).toList();
    }

    private DashScopeApiSpec.ChatCompletionRequestParameter toDashScopeRequestParameter(DashScopeChatOptions options, boolean stream) {
        if (options == null) {
            return new DashScopeApiSpec.ChatCompletionRequestParameter();
        }
        Boolean incrementalOutput = stream && options.getIncrementalOutput() != false;
        return new DashScopeApiSpec.ChatCompletionRequestParameter("message", options.getSeed(), options.getTopP(), options.getTopK(), options.getRepetitionPenalty(), options.getPresencePenalty(), options.getTemperature(), options.getStop(), options.getEnableSearch(), options.getSearchOptions(), options.getResponseFormat(), incrementalOutput, options.getTools(), options.getToolChoice(), options.getParallelToolCalls(), options.getEnableThinking(), options.getThinkingBudget(), options.getVlHighResolutionImages(), options.getVlEnableImageHwOutput(), options.getOcrOptions(), options.getLogprobs(), options.getTopLogProbs(), options.getTranslationOptions(), options.getStream(), options.getStreamOptions(), options.getModalities(), options.getAudio(), options.getMaxTokens(), options.getMaxInputTokens(), options.getAsrOptions(), options.getOutputFormat(), options.getExtraBody());
    }

    private Map<String, Object> mergeExtraBody(Map<String, Object> runtimeExtraBody, Map<String, Object> defaultExtraBody) {
        if (defaultExtraBody == null && runtimeExtraBody == null) {
            return null;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>();
        if (defaultExtraBody != null) {
            merged.putAll(defaultExtraBody);
        }
        if (runtimeExtraBody != null) {
            merged.putAll(runtimeExtraBody);
        }
        return merged.isEmpty() ? null : merged;
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public Builder mutate() {
        return new Builder(this);
    }

    public DashScopeChatModel clone() {
        return this.mutate().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DashScopeApi dashScopeApi;
        private DashScopeChatOptions defaultOptions = DashScopeChatOptions.builder().model(DEFAULT_MODEL_NAME).build();
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private ToolCallingManager toolCallingManager;
        private ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate = new DefaultToolExecutionEligibilityPredicate();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder(DashScopeChatModel dashScopeChatModel) {
            this.dashScopeApi = dashScopeChatModel.dashscopeApi;
            this.defaultOptions = dashScopeChatModel.defaultOptions;
            this.toolCallingManager = dashScopeChatModel.toolCallingManager;
            this.retryTemplate = dashScopeChatModel.retryTemplate;
            this.observationRegistry = dashScopeChatModel.observationRegistry;
            this.toolExecutionEligibilityPredicate = dashScopeChatModel.toolExecutionEligibilityPredicate;
        }

        public Builder dashScopeApi(DashScopeApi dashScopeApi) {
            this.dashScopeApi = dashScopeApi;
            return this;
        }

        public Builder defaultOptions(DashScopeChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder toolExecutionEligibilityPredicate(ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
            this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public DashScopeChatModel build() {
            if (this.toolCallingManager != null) {
                return new DashScopeChatModel(this.dashScopeApi, this.defaultOptions, this.toolCallingManager, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
            }
            return new DashScopeChatModel(this.dashScopeApi, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
        }
    }
}

