/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.audio;

import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioSpeechApi;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.audio.tts.TextToSpeechOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeAudioSpeechOptions
implements TextToSpeechOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="voice")
    private String voice;
    @JsonProperty(value="request_text_type")
    private DashScopeAudioSpeechApi.RequestTextType requestTextType = DashScopeAudioSpeechApi.RequestTextType.PLAIN_TEXT;
    @JsonProperty(value="sample_rate")
    private Integer sampleRate = 48000;
    @JsonProperty(value="volume")
    private Integer volume = 50;
    @JsonProperty(value="speed")
    private Double speed = 1.0;
    @JsonProperty(value="pitch")
    private Double pitch = 1.0;
    @JsonProperty(value="enable_word_timestamp")
    private Boolean enableWordTimestamp = false;
    @JsonProperty(value="enable_phoneme_timestamp")
    private Boolean enablePhonemeTimestamp = false;
    @JsonProperty(value="enable_ssml")
    private Boolean enableSsml;
    @JsonProperty(value="bit_rate")
    private Integer bitRate;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="language_hints")
    private List<String> languageHints;
    @JsonProperty(value="instruction")
    private String instruction;
    @JsonProperty(value="response_format")
    private DashScopeAudioSpeechApi.ResponseFormat responseFormat = DashScopeAudioSpeechApi.ResponseFormat.MP3;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String voice) {
        this.voice = voice;
    }

    public DashScopeAudioSpeechApi.RequestTextType getRequestTextType() {
        return this.requestTextType;
    }

    public void setRequestTextType(DashScopeAudioSpeechApi.RequestTextType requestTextType) {
        this.requestTextType = requestTextType;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Integer sampleRate) {
        this.sampleRate = sampleRate;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getPitch() {
        return this.pitch;
    }

    public void setPitch(Double pitch) {
        this.pitch = pitch;
    }

    public Boolean getEnableWordTimestamp() {
        return this.enableWordTimestamp;
    }

    public void setEnableWordTimestamp(Boolean enableWordTimestamp) {
        this.enableWordTimestamp = enableWordTimestamp;
    }

    public Boolean getEnablePhonemeTimestamp() {
        return this.enablePhonemeTimestamp;
    }

    public void setEnablePhonemeTimestamp(Boolean enablePhonemeTimestamp) {
        this.enablePhonemeTimestamp = enablePhonemeTimestamp;
    }

    public Boolean getEnableSsml() {
        return this.enableSsml;
    }

    public void setEnableSsml(Boolean enableSsml) {
        this.enableSsml = enableSsml;
    }

    public Integer getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(Integer bitRate) {
        this.bitRate = bitRate;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public List<String> getLanguageHints() {
        return this.languageHints;
    }

    public void setLanguageHints(List<String> languageHints) {
        this.languageHints = languageHints;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public DashScopeAudioSpeechApi.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(DashScopeAudioSpeechApi.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public String getFormat() {
        return this.responseFormat == null ? null : this.responseFormat.getValue();
    }

    public DashScopeAudioSpeechOptions copy() {
        return DashScopeAudioSpeechOptions.builder().model(this.model).text(this.text).voice(this.voice).requestTextType(this.requestTextType).sampleRate(this.sampleRate).volume(this.volume).speed(this.speed).pitch(this.pitch).enableWordTimestamp(this.enableWordTimestamp).enablePhonemeTimestamp(this.enablePhonemeTimestamp).enableSsml(this.enableSsml).bitRate(this.bitRate).seed(this.seed).languageHints(this.languageHints).instruction(this.instruction).responseFormat(this.responseFormat).build();
    }

    public static class Builder {
        private final DashScopeAudioSpeechOptions options = new DashScopeAudioSpeechOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder text(String text) {
            this.options.text = text;
            return this;
        }

        public Builder voice(String voice) {
            this.options.voice = voice;
            return this;
        }

        public Builder requestTextType(DashScopeAudioSpeechApi.RequestTextType requestTextType) {
            this.options.requestTextType = requestTextType;
            return this;
        }

        public Builder sampleRate(Integer sampleRate) {
            this.options.sampleRate = sampleRate;
            return this;
        }

        public Builder volume(Integer volume) {
            this.options.volume = volume;
            return this;
        }

        public Builder speed(Double speed) {
            this.options.speed = speed;
            return this;
        }

        public Builder responseFormat(DashScopeAudioSpeechApi.ResponseFormat format) {
            this.options.responseFormat = format;
            return this;
        }

        public Builder pitch(Double pitch) {
            this.options.pitch = pitch;
            return this;
        }

        public Builder enableWordTimestamp(Boolean enableWordTimestamp) {
            this.options.enableWordTimestamp = enableWordTimestamp;
            return this;
        }

        public Builder enablePhonemeTimestamp(Boolean enablePhonemeTimestamp) {
            this.options.enablePhonemeTimestamp = enablePhonemeTimestamp;
            return this;
        }

        public Builder enableSsml(Boolean enableSsml) {
            this.options.enableSsml = enableSsml;
            return this;
        }

        public Builder bitRate(Integer bitRate) {
            this.options.bitRate = bitRate;
            return this;
        }

        public Builder seed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder languageHints(List<String> languageHints) {
            this.options.languageHints = languageHints;
            return this;
        }

        public Builder instruction(String instruction) {
            this.options.instruction = instruction;
            return this;
        }

        public DashScopeAudioSpeechOptions build() {
            return this.options;
        }
    }
}

