/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tools;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import java.util.Map;
import java.util.Optional;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.lang.Nullable;

public final class ToolContextHelper {
    private ToolContextHelper() {
    }

    public static Optional<RunnableConfig> getConfig(@Nullable ToolContext toolContext) {
        if (toolContext == null) {
            return Optional.empty();
        }
        return ToolContextHelper.getMetadata(toolContext, "_AGENT_CONFIG_", RunnableConfig.class);
    }

    public static Optional<OverAllState> getState(@Nullable ToolContext toolContext) {
        if (toolContext == null) {
            return Optional.empty();
        }
        return ToolContextHelper.getMetadata(toolContext, "_AGENT_STATE_", OverAllState.class);
    }

    public static Optional<Map<String, Object>> getStateForUpdate(@Nullable ToolContext toolContext) {
        if (toolContext == null) {
            return Optional.empty();
        }
        return ToolContextHelper.getMetadata(toolContext, "_AGENT_STATE_FOR_UPDATE_", Map.class).map(map -> map);
    }

    public static <T> Optional<T> getMetadata(@Nullable ToolContext toolContext, String key, Class<T> type) {
        if (toolContext == null || key == null) {
            return Optional.empty();
        }
        Map context = toolContext.getContext();
        if (context == null) {
            return Optional.empty();
        }
        Object value = context.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (type.isInstance(value)) {
            return Optional.of(type.cast(value));
        }
        return Optional.empty();
    }

    public static <T> T getMetadataOrDefault(@Nullable ToolContext toolContext, String key, Class<T> type, T defaultValue) {
        return ToolContextHelper.getMetadata(toolContext, key, type).orElse(defaultValue);
    }

    public static boolean hasKey(@Nullable ToolContext toolContext, String key) {
        if (toolContext == null || key == null) {
            return false;
        }
        Map context = toolContext.getContext();
        if (context == null) {
            return false;
        }
        return context.containsKey(key);
    }

    public static Map<String, Object> getAllContext(@Nullable ToolContext toolContext) {
        if (toolContext == null) {
            return Map.of();
        }
        Map context = toolContext.getContext();
        if (context == null) {
            return Map.of();
        }
        return Map.copyOf(context);
    }
}

