/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tools;

import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.agent.tools.ShellSessionManager;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class ShellTool
implements BiFunction<Request, ToolContext, String> {
    private static final Logger log = LoggerFactory.getLogger(ShellTool.class);
    public static final String DEFAULT_TOOL_DESCRIPTION = "Execute a shell command inside a persistent session. Before running a command, confirm the working directory is correct (e.g., inspect with `ls` or `pwd`) and ensure any parent directories exist. Prefer absolute paths and quote paths containing spaces, such as `cd \"/path/with spaces\"`. Chain multiple commands with `&&` or `;` instead of embedding newlines. Avoid unnecessary `cd` usage unless explicitly required so the session remains stable. Outputs may be truncated when they become very large, and long running commands will be terminated once their configured timeout elapses.";
    private final ShellSessionManager sessionManager;

    public ShellTool(ShellSessionManager sessionManager) {
        if (sessionManager == null) {
            throw new IllegalArgumentException("ShellSessionManager cannot be null");
        }
        this.sessionManager = sessionManager;
    }

    @Override
    public String apply(Request request, ToolContext toolContext) {
        try {
            String command;
            RunnableConfig config = (RunnableConfig)toolContext.getContext().get("_AGENT_CONFIG_");
            if (Boolean.TRUE.equals(request.restart())) {
                log.info("Restarting shell session as requested.");
                this.sessionManager.restartSession(config);
                if (request.command() == null || request.command().trim().isEmpty()) {
                    return "Shell session restarted successfully.";
                }
            }
            if ((command = request.command()) == null || command.trim().isEmpty()) {
                return "Error: Command cannot be empty.";
            }
            log.info("Executing shell command: {}", (Object)command);
            ShellSessionManager.CommandResult result = this.sessionManager.executeCommand(command, config);
            return this.formatResult(result);
        }
        catch (Exception e) {
            log.error("Shell command execution failed unexpectedly.", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    private String formatResult(ShellSessionManager.CommandResult result) {
        StringBuilder outputBuilder = new StringBuilder();
        if (result.isTimedOut()) {
            outputBuilder.append("Error: Command timed out.");
            return outputBuilder.toString();
        }
        String output = result.getOutput();
        outputBuilder.append(output.isEmpty() ? "<no output>" : output);
        if (result.isTruncatedByLines()) {
            outputBuilder.append(String.format("\n\n... Output truncated at %d lines (observed %d).", this.sessionManager.getMaxOutputLines(), result.getTotalLines()));
        }
        if (result.isTruncatedByBytes() && this.sessionManager.getMaxOutputBytes() != null) {
            outputBuilder.append(String.format("\n\n... Output truncated at %d bytes (observed %d).", this.sessionManager.getMaxOutputBytes(), result.getTotalBytes()));
        }
        if (result.getExitCode() != null && result.getExitCode() != 0) {
            outputBuilder.append("\n\nExit code: ").append(result.getExitCode());
        }
        return outputBuilder.toString();
    }

    public ShellSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public static Builder builder(String workspaceRoot) {
        return new Builder(workspaceRoot);
    }

    public record Request(@JsonProperty(value="command") @JsonPropertyDescription(value="The command to execute in the shell.") String command, @JsonProperty(value="restart", defaultValue="false") @JsonPropertyDescription(value="Restart the shell session before executing the command.") Boolean restart) {
    }

    public static class Builder {
        private final String workspaceRoot;
        private String name = "shell";
        private String description = "Execute a shell command inside a persistent session. Before running a command, confirm the working directory is correct (e.g., inspect with `ls` or `pwd`) and ensure any parent directories exist. Prefer absolute paths and quote paths containing spaces, such as `cd \"/path/with spaces\"`. Chain multiple commands with `&&` or `;` instead of embedding newlines. Avoid unnecessary `cd` usage unless explicitly required so the session remains stable. Outputs may be truncated when they become very large, and long running commands will be terminated once their configured timeout elapses.";
        private List<String> startupCommands;
        private List<String> shutdownCommands;
        private long commandTimeout = 60000L;
        private int maxOutputLines = 1000;
        private List<String> shellCommand;
        private Map<String, String> environment;

        public Builder(String workspaceRoot) {
            this.workspaceRoot = workspaceRoot;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withStartupCommands(List<String> startupCommands) {
            this.startupCommands = startupCommands;
            return this;
        }

        public Builder withShutdownCommands(List<String> shutdownCommands) {
            this.shutdownCommands = shutdownCommands;
            return this;
        }

        public Builder withCommandTimeout(long commandTimeout) {
            this.commandTimeout = commandTimeout;
            return this;
        }

        public Builder withMaxOutputLines(int maxOutputLines) {
            this.maxOutputLines = maxOutputLines;
            return this;
        }

        public Builder withShellCommand(List<String> shellCommand) {
            this.shellCommand = shellCommand;
            return this;
        }

        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public ToolCallback build() {
            ShellSessionManager.Builder sessionManagerBuilder = ShellSessionManager.builder().workspaceRoot(Path.of(this.workspaceRoot, new String[0])).commandTimeout(this.commandTimeout).maxOutputLines(this.maxOutputLines);
            if (this.startupCommands != null) {
                sessionManagerBuilder.setStartupCommand(this.startupCommands);
            }
            if (this.shutdownCommands != null) {
                sessionManagerBuilder.setShutdownCommand(this.shutdownCommands);
            }
            if (this.shellCommand != null) {
                sessionManagerBuilder.shellCommand(this.shellCommand);
            }
            if (this.environment != null) {
                sessionManagerBuilder.environment(this.environment);
            }
            ShellSessionManager sessionManager = sessionManagerBuilder.build();
            ShellTool shellTool = new ShellTool(sessionManager);
            return FunctionToolCallback.builder((String)this.name, (BiFunction)shellTool).description(this.description).inputType(Request.class).build();
        }
    }
}

