/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tool;

import com.alibaba.cloud.ai.graph.KeyStrategy;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ToolStateCollector {
    private final ConcurrentMap<Integer, Map<String, Object>> toolUpdatesByIndex = new ConcurrentHashMap<Integer, Map<String, Object>>();
    private final int totalTools;
    private final Map<String, KeyStrategy> keyStrategies;
    private final AtomicBoolean merged = new AtomicBoolean(false);

    public ToolStateCollector(int totalTools, Map<String, KeyStrategy> keyStrategies) {
        this.totalTools = totalTools;
        this.keyStrategies = keyStrategies != null ? keyStrategies : Collections.emptyMap();
    }

    public Map<String, Object> createToolUpdateMap(int index) {
        if (this.merged.get()) {
            throw new IllegalStateException("Cannot create update map after mergeAll() has been called");
        }
        ConcurrentHashMap<String, Object> updateMap = new ConcurrentHashMap<String, Object>();
        this.toolUpdatesByIndex.put(index, updateMap);
        return updateMap;
    }

    public void discardToolUpdateMap(int index) {
        this.toolUpdatesByIndex.remove(index);
    }

    public Map<String, Object> mergeAll() {
        if (!this.merged.compareAndSet(false, true)) {
            throw new IllegalStateException("mergeAll() can only be called once");
        }
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (int i = 0; i < this.totalTools; ++i) {
            Map toolUpdate = (Map)this.toolUpdatesByIndex.get(i);
            if (toolUpdate == null || toolUpdate.isEmpty()) continue;
            for (Map.Entry entry : toolUpdate.entrySet()) {
                String key = (String)entry.getKey();
                Object newValue = entry.getValue();
                Object existingValue = result.get(key);
                if (existingValue == null) {
                    result.put(key, newValue);
                    continue;
                }
                KeyStrategy strategy = this.keyStrategies.getOrDefault(key, KeyStrategy.REPLACE);
                result.put(key, strategy.apply(existingValue, newValue));
            }
        }
        return result;
    }

    public int getCompletedCount() {
        return this.toolUpdatesByIndex.size();
    }

    public boolean isMerged() {
        return this.merged.get();
    }
}

