/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tool;

import com.alibaba.cloud.ai.graph.agent.tool.CancellationToken;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultCancellationToken
implements CancellationToken {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final List<CancellationCallback> callbacks = new CopyOnWriteArrayList<CancellationCallback>();

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public void onCancel(Runnable callback) {
        CancellationCallback cancellationCallback = new CancellationCallback(callback);
        this.callbacks.add(cancellationCallback);
        if (this.cancelled.get()) {
            cancellationCallback.runOnce();
        }
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.callbacks.forEach(CancellationCallback::runOnce);
        }
    }

    public static DefaultCancellationToken linkedTo(CompletableFuture<?> future) {
        DefaultCancellationToken token = new DefaultCancellationToken();
        future.whenComplete((result, error) -> {
            if (future.isCancelled()) {
                token.cancel();
            }
        });
        return token;
    }

    private static final class CancellationCallback {
        private final Runnable delegate;
        private final AtomicBoolean executed = new AtomicBoolean(false);

        private CancellationCallback(Runnable delegate) {
            this.delegate = delegate;
        }

        private void runOnce() {
            if (this.executed.compareAndSet(false, true)) {
                this.delegate.run();
            }
        }
    }
}

