/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tool;

import com.alibaba.cloud.ai.graph.agent.tool.AsyncToolCallback;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.metadata.ToolMetadata;

public class AsyncToolCallbackAdapter
implements AsyncToolCallback {
    private final ToolCallback delegate;
    private final Executor executor;
    private final Duration timeout;

    public AsyncToolCallbackAdapter(ToolCallback delegate, Executor executor) {
        this(delegate, executor, Duration.ofMinutes(5L));
    }

    public AsyncToolCallbackAdapter(ToolCallback delegate, Executor executor, Duration timeout) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        this.executor = Objects.requireNonNull(executor, "executor must not be null");
        this.timeout = Objects.requireNonNull(timeout, "timeout must not be null");
    }

    @Override
    public CompletableFuture<String> callAsync(String arguments, ToolContext context) {
        return CompletableFuture.supplyAsync(() -> this.delegate.call(arguments, context), this.executor);
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    public ToolDefinition getToolDefinition() {
        return this.delegate.getToolDefinition();
    }

    public ToolMetadata getToolMetadata() {
        return this.delegate.getToolMetadata();
    }

    public String call(String toolInput) {
        return this.delegate.call(toolInput);
    }

    @Override
    public String call(String toolInput, ToolContext toolContext) {
        return this.delegate.call(toolInput, toolContext);
    }

    public ToolCallback getDelegate() {
        return this.delegate;
    }

    public static AsyncToolCallback wrapIfNeeded(ToolCallback callback, Executor executor) {
        return AsyncToolCallbackAdapter.wrapIfNeeded(callback, executor, Duration.ofMinutes(5L));
    }

    public static AsyncToolCallback wrapIfNeeded(ToolCallback callback, Executor executor, Duration timeout) {
        Objects.requireNonNull(callback, "callback must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(timeout, "timeout must not be null");
        if (callback instanceof AsyncToolCallback) {
            AsyncToolCallback async = (AsyncToolCallback)callback;
            return async;
        }
        return new AsyncToolCallbackAdapter(callback, executor, timeout);
    }
}

