/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.tool;

import com.alibaba.cloud.ai.graph.agent.tool.StateAwareToolCallback;
import com.alibaba.cloud.ai.graph.agent.tool.ToolCancelledException;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.springframework.ai.chat.model.ToolContext;

public interface AsyncToolCallback
extends StateAwareToolCallback {
    public CompletableFuture<String> callAsync(String var1, ToolContext var2);

    default public String call(String arguments, ToolContext context) {
        try {
            return this.callAsync(arguments, context).join();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)cause;
                throw re;
            }
            if (cause instanceof Error) {
                Error err = (Error)cause;
                throw err;
            }
            throw new RuntimeException("Async tool execution failed", cause);
        }
        catch (CancellationException e) {
            throw new ToolCancelledException("Tool execution was cancelled", e);
        }
    }

    default public boolean isAsync() {
        return true;
    }

    default public Duration getTimeout() {
        return Duration.ofMinutes(5L);
    }
}

