/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.renderer;

import com.alibaba.cloud.ai.graph.agent.renderer.Slf4jStErrorListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.ValidationMode;
import org.springframework.util.Assert;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.Compiler;

public class SaaStTemplateRenderer
implements TemplateRenderer {
    private static final Logger logger = LoggerFactory.getLogger(SaaStTemplateRenderer.class);
    private static final String VALIDATION_MESSAGE = "Not all variables were replaced in the template. Missing variable names are: %s.";
    private static final char DEFAULT_START_DELIMITER_TOKEN = '{';
    private static final char DEFAULT_END_DELIMITER_TOKEN = '}';
    private static final String DEFAULT_START_DELIMITER_STRING = "{";
    private static final String DEFAULT_END_DELIMITER_STRING = "}";
    private static final ValidationMode DEFAULT_VALIDATION_MODE = ValidationMode.THROW;
    private static final boolean DEFAULT_VALIDATE_ST_FUNCTIONS = false;
    private static final char TEMP_START_DELIMITER = '\u0001';
    private static final char TEMP_END_DELIMITER = '\u0002';
    private final char startDelimiterToken;
    private final char endDelimiterToken;
    private final String startDelimiterString;
    private final String endDelimiterString;
    private final boolean useStringDelimiters;
    private final ValidationMode validationMode;
    private final boolean validateStFunctions;
    private static final String JSON_OPEN_PLACEHOLDER = "\ue000";
    private static final String JSON_CLOSE_PLACEHOLDER = "\ue001";

    public SaaStTemplateRenderer(char startDelimiterToken, char endDelimiterToken, ValidationMode validationMode, boolean validateStFunctions) {
        Assert.notNull((Object)validationMode, (String)"validationMode cannot be null");
        this.startDelimiterToken = startDelimiterToken;
        this.endDelimiterToken = endDelimiterToken;
        this.startDelimiterString = String.valueOf(startDelimiterToken);
        this.endDelimiterString = String.valueOf(endDelimiterToken);
        this.useStringDelimiters = false;
        this.validationMode = validationMode;
        this.validateStFunctions = validateStFunctions;
    }

    public SaaStTemplateRenderer(String startDelimiterString, String endDelimiterString, ValidationMode validationMode, boolean validateStFunctions) {
        Assert.notNull((Object)validationMode, (String)"validationMode cannot be null");
        Assert.hasText((String)startDelimiterString, (String)"startDelimiterString cannot be null or empty");
        Assert.hasText((String)endDelimiterString, (String)"endDelimiterString cannot be null or empty");
        this.startDelimiterString = startDelimiterString;
        this.endDelimiterString = endDelimiterString;
        this.useStringDelimiters = true;
        this.startDelimiterToken = '\u0001';
        this.endDelimiterToken = (char)2;
        this.validationMode = validationMode;
        this.validateStFunctions = validateStFunctions;
    }

    public String apply(String template, Map<String, Object> variables) {
        Assert.hasText((String)template, (String)"template cannot be null or empty");
        Assert.notNull(variables, (String)"variables cannot be null");
        Assert.noNullElements(variables.keySet(), (String)"variables keys cannot be null");
        ST st = this.createST(template);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            st.add(entry.getKey(), entry.getValue());
        }
        if (this.validationMode != ValidationMode.NONE) {
            this.validate(st, variables);
        }
        String result = st.render();
        if (!this.useStringDelimiters) {
            result = this.restoreJsonContentInResult(result);
        }
        return result;
    }

    private ST createST(String template) {
        try {
            String processedTemplate = template;
            processedTemplate = this.useStringDelimiters ? this.convertStringDelimitersToChar(template) : this.protectJsonContent(template);
            STGroup group = new STGroup(this.startDelimiterToken, this.endDelimiterToken);
            group.setListener((STErrorListener)new Slf4jStErrorListener(logger));
            return new ST(group, processedTemplate);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The template string is not valid.", ex);
        }
    }

    private String protectJsonContent(String template) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        int len = template.length();
        while (i < len) {
            int braceIdx = template.indexOf(this.startDelimiterToken, i);
            if (braceIdx == -1) {
                result.append(template.substring(i));
                break;
            }
            result.append(template.substring(i, braceIdx));
            int afterBrace = braceIdx + 1;
            if (afterBrace < len) {
                boolean isTemplateVar;
                char nextChar = template.charAt(afterBrace);
                boolean bl = isTemplateVar = Character.isLetter(nextChar) || nextChar == '_' || nextChar == '$';
                if (!isTemplateVar) {
                    int closeBraceIdx;
                    boolean looksLikeJson = false;
                    if (nextChar == '\"' || nextChar == '\'' || nextChar == '[' || nextChar == '{') {
                        looksLikeJson = true;
                    } else if (Character.isWhitespace(nextChar)) {
                        char afterWhitespace;
                        int nextNonWhitespace;
                        for (nextNonWhitespace = afterBrace + 1; nextNonWhitespace < len && Character.isWhitespace(template.charAt(nextNonWhitespace)); ++nextNonWhitespace) {
                        }
                        if (nextNonWhitespace < len && ((afterWhitespace = template.charAt(nextNonWhitespace)) == '\"' || afterWhitespace == '\'' || afterWhitespace == '[')) {
                            looksLikeJson = true;
                        }
                    }
                    if (looksLikeJson && (closeBraceIdx = this.findMatchingJsonBrace(template, afterBrace)) != -1) {
                        result.append(JSON_OPEN_PLACEHOLDER);
                        result.append(template.substring(afterBrace, closeBraceIdx));
                        result.append(JSON_CLOSE_PLACEHOLDER);
                        i = closeBraceIdx + 1;
                        continue;
                    }
                }
            }
            result.append(this.startDelimiterToken);
            i = braceIdx + 1;
        }
        return result.toString();
    }

    private int findMatchingJsonBrace(String template, int startPos) {
        int depth = 1;
        int len = template.length();
        boolean inString = false;
        char stringChar = '\u0000';
        for (int i = startPos; i < len && depth > 0; ++i) {
            char ch = template.charAt(i);
            if (!(inString || ch != '\"' && ch != '\'')) {
                inString = true;
                stringChar = ch;
            } else if (inString && ch == stringChar && (i == 0 || template.charAt(i - 1) != '\\')) {
                inString = false;
                stringChar = '\u0000';
            }
            if (inString) continue;
            if (ch == this.startDelimiterToken) {
                ++depth;
                continue;
            }
            if (ch != this.endDelimiterToken || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private String restoreJsonContentInResult(String result) {
        return result.replace(JSON_OPEN_PLACEHOLDER, String.valueOf(this.startDelimiterToken)).replace(JSON_CLOSE_PLACEHOLDER, String.valueOf(this.endDelimiterToken));
    }

    private String convertStringDelimitersToChar(String template) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        int len = template.length();
        int startLen = this.startDelimiterString.length();
        int endLen = this.endDelimiterString.length();
        while (i < len) {
            int endIdx;
            char nextChar;
            int startIdx = template.indexOf(this.startDelimiterString, i);
            if (startIdx == -1) {
                result.append(template.substring(i));
                break;
            }
            result.append(template.substring(i, startIdx));
            int afterStart = startIdx + startLen;
            if (afterStart < len && (Character.isLetter(nextChar = template.charAt(afterStart)) || nextChar == '_' || nextChar == '$' || Character.isWhitespace(nextChar)) && (endIdx = this.findMatchingEndDelimiter(template, afterStart, startLen, endLen)) != -1) {
                String variableContent = template.substring(afterStart, endIdx);
                variableContent = variableContent.trim();
                result.append(this.startDelimiterToken);
                result.append(variableContent);
                result.append(this.endDelimiterToken);
                i = endIdx + endLen;
                continue;
            }
            result.append(this.startDelimiterString);
            i = startIdx + startLen;
        }
        return result.toString();
    }

    private int findMatchingEndDelimiter(String template, int startPos, int startLen, int endLen) {
        int depth = 1;
        int i = startPos;
        int len = template.length();
        boolean inString = false;
        char stringChar = '\u0000';
        while (i < len) {
            String potentialEnd;
            String potentialStart;
            if (!inString) {
                char ch = template.charAt(i);
                if (ch == '\"' || ch == '\'') {
                    inString = true;
                    stringChar = ch;
                    ++i;
                    continue;
                }
            } else {
                char ch = template.charAt(i);
                if (ch == stringChar && (i == 0 || template.charAt(i - 1) != '\\')) {
                    inString = false;
                    stringChar = '\u0000';
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            if (i + startLen <= len && (potentialStart = template.substring(i, i + startLen)).equals(this.startDelimiterString)) {
                ++depth;
                i += startLen;
                continue;
            }
            if (i + endLen <= len && (potentialEnd = template.substring(i, i + endLen)).equals(this.endDelimiterString)) {
                if (--depth == 0) {
                    return i;
                }
                i += endLen;
                continue;
            }
            ++i;
        }
        return -1;
    }

    private Set<String> validate(ST st, Map<String, Object> templateVariables) {
        Set<String> templateTokens = this.getInputVariables(st);
        Set<String> modelKeys = templateVariables.keySet();
        HashSet<String> missingVariables = new HashSet<String>(templateTokens);
        missingVariables.removeAll(modelKeys);
        if (!missingVariables.isEmpty()) {
            if (this.validationMode == ValidationMode.WARN) {
                logger.warn(VALIDATION_MESSAGE.formatted(missingVariables));
            } else if (this.validationMode == ValidationMode.THROW) {
                throw new IllegalStateException(VALIDATION_MESSAGE.formatted(missingVariables));
            }
        }
        return missingVariables;
    }

    private Set<String> getInputVariables(ST st) {
        TokenStream tokens = st.impl.tokens;
        HashSet<String> inputVariables = new HashSet<String>();
        boolean isInsideList = false;
        for (int i = 0; i < tokens.size(); ++i) {
            String varName;
            boolean isAfterDot;
            Token token = tokens.get(i);
            if (token.getType() == 23 && i + 1 < tokens.size() && tokens.get(i + 1).getType() == 25) {
                String text;
                if (i + 2 >= tokens.size() || tokens.get(i + 2).getType() != 13 || Compiler.funcs.containsKey(text = tokens.get(i + 1).getText()) && !this.validateStFunctions) continue;
                inputVariables.add(text);
                isInsideList = true;
                continue;
            }
            if (token.getType() == 24) {
                isInsideList = false;
                continue;
            }
            if (isInsideList || token.getType() != 25) continue;
            boolean isFunctionCall = i + 1 < tokens.size() && tokens.get(i + 1).getType() == 14;
            boolean bl = isAfterDot = i > 0 && tokens.get(i - 1).getType() == 19;
            if (isFunctionCall || isAfterDot || Compiler.funcs.containsKey(varName = token.getText()) && !this.validateStFunctions) continue;
            inputVariables.add(varName);
        }
        return inputVariables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private char startDelimiterToken = (char)123;
        private char endDelimiterToken = (char)125;
        private String startDelimiterString = "{";
        private String endDelimiterString = "}";
        private boolean useStringDelimiters = false;
        private ValidationMode validationMode = DEFAULT_VALIDATION_MODE;
        private boolean validateStFunctions = false;

        private Builder() {
        }

        public Builder startDelimiterToken(char startDelimiterToken) {
            this.startDelimiterToken = startDelimiterToken;
            this.startDelimiterString = String.valueOf(startDelimiterToken);
            this.useStringDelimiters = false;
            return this;
        }

        public Builder endDelimiterToken(char endDelimiterToken) {
            this.endDelimiterToken = endDelimiterToken;
            this.endDelimiterString = String.valueOf(endDelimiterToken);
            this.useStringDelimiters = false;
            return this;
        }

        public Builder startDelimiter(String startDelimiterString) {
            Assert.hasText((String)startDelimiterString, (String)"startDelimiterString cannot be null or empty");
            this.startDelimiterString = startDelimiterString;
            this.useStringDelimiters = true;
            return this;
        }

        public Builder endDelimiter(String endDelimiterString) {
            Assert.hasText((String)endDelimiterString, (String)"endDelimiterString cannot be null or empty");
            this.endDelimiterString = endDelimiterString;
            this.useStringDelimiters = true;
            return this;
        }

        public Builder validationMode(ValidationMode validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        public Builder validateStFunctions() {
            this.validateStFunctions = true;
            return this;
        }

        public SaaStTemplateRenderer build() {
            if (this.useStringDelimiters) {
                return new SaaStTemplateRenderer(this.startDelimiterString, this.endDelimiterString, this.validationMode, this.validateStFunctions);
            }
            return new SaaStTemplateRenderer(this.startDelimiterToken, this.endDelimiterToken, this.validationMode, this.validateStFunctions);
        }
    }
}

