/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.action.NodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.interceptor.InterceptorChain;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallExecutionContext;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallResponse;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import com.alibaba.cloud.ai.graph.agent.tool.AsyncToolCallback;
import com.alibaba.cloud.ai.graph.agent.tool.AsyncToolCallbackAdapter;
import com.alibaba.cloud.ai.graph.agent.tool.CancellableAsyncToolCallback;
import com.alibaba.cloud.ai.graph.agent.tool.DefaultCancellationToken;
import com.alibaba.cloud.ai.graph.agent.tool.StateAwareToolCallback;
import com.alibaba.cloud.ai.graph.agent.tool.ToolCancelledException;
import com.alibaba.cloud.ai.graph.agent.tool.ToolStateCollector;
import com.alibaba.cloud.ai.graph.internal.node.ParallelNode;
import com.alibaba.cloud.ai.graph.state.RemoveByHash;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.execution.DefaultToolExecutionExceptionProcessor;
import org.springframework.ai.tool.execution.ToolExecutionException;
import org.springframework.ai.tool.execution.ToolExecutionExceptionProcessor;
import org.springframework.ai.tool.function.FunctionToolCallback;
import org.springframework.ai.tool.method.MethodToolCallback;
import org.springframework.ai.tool.resolution.ToolCallbackResolver;

public class AgentToolNode
implements NodeActionWithConfig {
    private static final Logger logger = LoggerFactory.getLogger(AgentToolNode.class);
    private final String agentName;
    private final boolean enableActingLog;
    private final boolean parallelToolExecution;
    private final int maxParallelTools;
    private final Duration toolExecutionTimeout;
    private final boolean wrapSyncToolsAsAsync;
    private List<ToolCallback> toolCallbacks;
    private Map<String, Object> toolContext;
    private List<ToolInterceptor> toolInterceptors = new ArrayList<ToolInterceptor>();
    private ToolCallbackResolver toolCallbackResolver;
    private ToolExecutionExceptionProcessor toolExecutionExceptionProcessor;

    public AgentToolNode(Builder builder) {
        this.agentName = builder.agentName;
        this.enableActingLog = builder.enableActingLog;
        this.toolCallbackResolver = builder.toolCallbackResolver;
        this.toolCallbacks = builder.toolCallbacks;
        this.toolContext = builder.toolContext;
        this.toolExecutionExceptionProcessor = builder.toolExecutionExceptionProcessor;
        this.parallelToolExecution = builder.parallelToolExecution;
        this.maxParallelTools = builder.maxParallelTools;
        this.toolExecutionTimeout = builder.toolExecutionTimeout;
        this.wrapSyncToolsAsAsync = builder.wrapSyncToolsAsAsync;
    }

    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        this.toolCallbacks = toolCallbacks;
    }

    public void setToolInterceptors(List<ToolInterceptor> toolInterceptors) {
        this.toolInterceptors = toolInterceptors;
    }

    void setToolCallbackResolver(ToolCallbackResolver toolCallbackResolver) {
        this.toolCallbackResolver = toolCallbackResolver;
    }

    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    public Map<String, Object> apply(OverAllState state, RunnableConfig config) throws Exception {
        List messages = (List)state.value("messages").orElseThrow();
        Message lastMessage = (Message)messages.get(messages.size() - 1);
        if (lastMessage instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)lastMessage;
            List toolCalls = assistantMessage.getToolCalls();
            if (this.enableActingLog) {
                logger.info("[ThreadId {}] Agent {} acting with {} tools.", new Object[]{config.threadId().orElse("$default"), this.agentName, toolCalls.size()});
            }
            if (this.parallelToolExecution && toolCalls.size() > 1) {
                return this.executeToolCallsParallel(toolCalls, state, config);
            }
            return this.executeToolCallsSequential(toolCalls, state, config);
        }
        if (lastMessage instanceof ToolResponseMessage) {
            ToolResponseMessage toolResponseMessage = (ToolResponseMessage)lastMessage;
            return this.handlePartialToolResponses(toolResponseMessage, messages, state, config);
        }
        throw new IllegalStateException("Last message is neither an AssistantMessage nor a ToolResponseMessage");
    }

    private Map<String, Object> executeToolCallsSequential(List<AssistantMessage.ToolCall> toolCalls, OverAllState state, RunnableConfig config) {
        HashMap<String, Object> updatedState = new HashMap<String, Object>();
        HashMap<String, Object> mergedUpdates = new HashMap<String, Object>();
        ArrayList<ToolResponseMessage.ToolResponse> toolResponses = new ArrayList<ToolResponseMessage.ToolResponse>();
        Boolean returnDirect = null;
        for (AssistantMessage.ToolCall toolCall : toolCalls) {
            ConcurrentHashMap<String, Object> toolSpecificUpdate = new ConcurrentHashMap<String, Object>();
            ToolCallResponse response = this.executeToolCallWithInterceptors(toolCall, state, config, toolSpecificUpdate, false);
            toolResponses.add(response.toToolResponse());
            returnDirect = this.shouldReturnDirect(toolCall, returnDirect, config);
            mergedUpdates.putAll(toolSpecificUpdate);
        }
        ToolResponseMessage.Builder builder = ToolResponseMessage.builder().responses(toolResponses);
        if (returnDirect != null && returnDirect.booleanValue()) {
            builder.metadata(Map.of("finishReason", "returnDirect"));
        }
        ToolResponseMessage toolResponseMessage = builder.build();
        if (this.enableActingLog) {
            logger.info("[ThreadId {}] Agent {} acting returned: {}", new Object[]{config.threadId().orElse("$default"), this.agentName, toolResponseMessage});
        }
        updatedState.put("messages", toolResponseMessage);
        updatedState.putAll(mergedUpdates);
        return updatedState;
    }

    private Map<String, Object> executeToolCallsParallel(List<AssistantMessage.ToolCall> toolCalls, OverAllState state, RunnableConfig config) {
        if (this.wrapSyncToolsAsAsync && logger.isDebugEnabled()) {
            logger.debug("Parallel execution mode: wrapSyncToolsAsAsync is ignored to avoid executor starvation. Sync tools will execute directly within the parallel runAsync context.");
        }
        Executor executor = this.getToolExecutor(config);
        OverAllState stateSnapshot = state.snapShot().orElse(state);
        ToolStateCollector stateCollector = new ToolStateCollector(toolCalls.size(), state.keyStrategies());
        AtomicReferenceArray orderedResponses = new AtomicReferenceArray(toolCalls.size());
        List failures = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap cancellationTokens = new ConcurrentHashMap();
        Semaphore semaphore = new Semaphore(this.maxParallelTools);
        List<CompletableFuture> futures = IntStream.range(0, toolCalls.size()).mapToObj(index -> {
            AssistantMessage.ToolCall toolCall = (AssistantMessage.ToolCall)toolCalls.get(index);
            Map<String, Object> toolSpecificUpdate = stateCollector.createToolUpdateMap(index);
            return CompletableFuture.runAsync(() -> {
                try {
                    semaphore.acquire();
                    try {
                        ToolCallResponse response = this.executeToolCallWithInterceptors(toolCall, stateSnapshot, config, toolSpecificUpdate, true, cancellationTokens, index);
                        orderedResponses.compareAndSet(index, null, response);
                    }
                    finally {
                        semaphore.release();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    failures.add(e);
                    orderedResponses.compareAndSet(index, null, ToolCallResponse.error(toolCall.id(), toolCall.name(), "Tool execution was interrupted"));
                }
            }, executor).orTimeout(this.toolExecutionTimeout.toMillis(), TimeUnit.MILLISECONDS).exceptionally(ex -> {
                Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
                ToolCallResponse errorResponse = ToolCallResponse.error(toolCall.id(), toolCall.name(), this.extractErrorMessage(cause));
                if (orderedResponses.compareAndSet(index, null, errorResponse)) {
                    if (cause instanceof TimeoutException) {
                        stateCollector.discardToolUpdateMap(index);
                        DefaultCancellationToken token = (DefaultCancellationToken)cancellationTokens.get(index);
                        if (token != null) {
                            token.cancel();
                            logger.debug("Cancelled tool {} at index {} due to outer timeout", (Object)toolCall.name(), (Object)index);
                        }
                    }
                    failures.add(ex);
                }
                return null;
            });
        }).toList();
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        HashMap<String, Object> updatedState = new HashMap<String, Object>();
        ArrayList<ToolResponseMessage.ToolResponse> toolResponses = new ArrayList<ToolResponseMessage.ToolResponse>();
        Boolean returnDirect = null;
        for (int i = 0; i < orderedResponses.length(); ++i) {
            ToolCallResponse response = (ToolCallResponse)orderedResponses.get(i);
            if (response == null) {
                AssistantMessage.ToolCall toolCall = toolCalls.get(i);
                response = ToolCallResponse.error(toolCall.id(), toolCall.name(), "Tool execution did not produce a response");
                logger.warn("Tool {} at index {} has null response, using error fallback", (Object)toolCall.name(), (Object)i);
            }
            toolResponses.add(response.toToolResponse());
            returnDirect = this.shouldReturnDirect(toolCalls.get(i), returnDirect, config);
        }
        ToolResponseMessage.Builder builder = ToolResponseMessage.builder().responses(toolResponses);
        if (returnDirect != null && returnDirect.booleanValue()) {
            builder.metadata(Map.of("finishReason", "returnDirect"));
        }
        updatedState.put("messages", builder.build());
        updatedState.putAll(stateCollector.mergeAll());
        if (this.enableActingLog) {
            logger.info("[ThreadId {}] Agent {} parallel tool execution completed. {} tools, {} failures.", new Object[]{config.threadId().orElse("$default"), this.agentName, toolCalls.size(), failures.size()});
        }
        return updatedState;
    }

    private Map<String, Object> handlePartialToolResponses(ToolResponseMessage toolResponseMessage, List<Message> messages, OverAllState state, RunnableConfig config) {
        if (messages.size() < 2) {
            throw new IllegalStateException("Cannot find AssistantMessage before ToolResponseMessage");
        }
        Message secondLastMessage = messages.get(messages.size() - 2);
        if (!(secondLastMessage instanceof AssistantMessage)) {
            throw new IllegalStateException("Message before ToolResponseMessage is not an AssistantMessage");
        }
        AssistantMessage assistantMessage = (AssistantMessage)secondLastMessage;
        List existingResponses = toolResponseMessage.getResponses();
        Set executedToolIds = existingResponses.stream().map(ToolResponseMessage.ToolResponse::id).collect(Collectors.toSet());
        List<AssistantMessage.ToolCall> remainingToolCalls = assistantMessage.getToolCalls().stream().filter(tc -> !executedToolIds.contains(tc.id())).toList();
        if (remainingToolCalls.isEmpty()) {
            return Map.of();
        }
        if (this.enableActingLog) {
            logger.info("[ThreadId {}] Agent {} acting with {} tools ({} already completed).", new Object[]{config.threadId().orElse("$default"), this.agentName, assistantMessage.getToolCalls().size(), existingResponses.size()});
        }
        Map<String, Object> newResults = this.parallelToolExecution && remainingToolCalls.size() > 1 ? this.executeToolCallsParallel(remainingToolCalls, state, config) : this.executeToolCallsSequential(remainingToolCalls, state, config);
        ToolResponseMessage newToolResponseMessage = (ToolResponseMessage)newResults.get("messages");
        ArrayList allResponses = new ArrayList(existingResponses);
        allResponses.addAll(newToolResponseMessage.getResponses());
        Boolean returnDirect = null;
        for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
            returnDirect = this.shouldReturnDirect(toolCall, returnDirect, config);
        }
        HashMap<String, Object> updatedState = new HashMap<String, Object>(newResults);
        ArrayList<Object> newMessages = new ArrayList<Object>();
        ToolResponseMessage.Builder builder = ToolResponseMessage.builder().responses(allResponses);
        if (returnDirect != null && returnDirect.booleanValue()) {
            builder.metadata(Map.of("finishReason", "returnDirect"));
        }
        newMessages.add(builder.build());
        newMessages.add(new RemoveByHash((Object)toolResponseMessage));
        updatedState.put("messages", newMessages);
        if (this.enableActingLog) {
            logger.info("[ThreadId {}] Agent {} acting successfully returned.", (Object)config.threadId().orElse("$default"), (Object)this.agentName);
        }
        return updatedState;
    }

    private Boolean shouldReturnDirect(AssistantMessage.ToolCall toolCall, Boolean returnDirect, RunnableConfig config) {
        ToolCallback toolCallback = this.resolve(toolCall.name(), config);
        if (toolCallback == null) {
            return returnDirect;
        }
        returnDirect = returnDirect == null ? Boolean.valueOf(toolCallback.getToolMetadata().returnDirect()) : Boolean.valueOf(returnDirect != false && toolCallback.getToolMetadata().returnDirect());
        return returnDirect;
    }

    private ToolCallResponse executeToolCallWithInterceptors(AssistantMessage.ToolCall toolCall, OverAllState state, RunnableConfig config, Map<String, Object> extraStateFromToolCall, boolean inParallelExecution) {
        return this.executeToolCallWithInterceptors(toolCall, state, config, extraStateFromToolCall, inParallelExecution, null, -1);
    }

    private ToolCallResponse executeToolCallWithInterceptors(AssistantMessage.ToolCall toolCall, OverAllState state, RunnableConfig config, Map<String, Object> extraStateFromToolCall, boolean inParallelExecution, Map<Integer, DefaultCancellationToken> cancellationTokens, int toolIndex) {
        ToolCallRequest request = ToolCallRequest.builder().toolCall(toolCall).context(config.metadata().orElse(new HashMap())).executionContext(new ToolCallExecutionContext(config, state)).build();
        ToolCallHandler baseHandler = req -> {
            ToolCallback toolCallback = this.resolve(req.getToolName(), config);
            if (toolCallback == null) {
                logger.warn("LLM may have adapted the tool name '{}', especially if the name was truncated due to length limits. If this is the case, you can customize the prefixing and processing logic using McpToolNamePrefixGenerator", (Object)req.getToolName());
                throw new IllegalStateException("No ToolCallback found for tool name: " + req.getToolName());
            }
            if (this.enableActingLog) {
                logger.info("[ThreadId {}] Agent {} acting, executing tool {}.", new Object[]{config.threadId().orElse("$default"), this.agentName, req.getToolName()});
            }
            HashMap<String, Object> toolContextMap = new HashMap<String, Object>(this.toolContext);
            toolContextMap.putAll(req.getContext());
            if (toolCallback instanceof StateAwareToolCallback || toolCallback instanceof FunctionToolCallback || toolCallback instanceof MethodToolCallback) {
                toolContextMap.putAll(Map.of("_AGENT_STATE_", state, "_AGENT_CONFIG_", config, "_AGENT_STATE_FOR_UPDATE_", extraStateFromToolCall));
            }
            return this.executeToolByType(toolCallback, req, toolContextMap, config, extraStateFromToolCall, inParallelExecution, cancellationTokens, toolIndex);
        };
        ToolCallHandler chainedHandler = InterceptorChain.chainToolInterceptors(this.toolInterceptors, baseHandler);
        return chainedHandler.call(request);
    }

    private ToolCallResponse executeToolByType(ToolCallback toolCallback, ToolCallRequest request, Map<String, Object> toolContextMap, RunnableConfig config, Map<String, Object> extraStateFromToolCall, boolean inParallelExecution) {
        return this.executeToolByType(toolCallback, request, toolContextMap, config, extraStateFromToolCall, inParallelExecution, null, -1);
    }

    private ToolCallResponse executeToolByType(ToolCallback toolCallback, ToolCallRequest request, Map<String, Object> toolContextMap, RunnableConfig config, Map<String, Object> extraStateFromToolCall, boolean inParallelExecution, Map<Integer, DefaultCancellationToken> cancellationTokens, int toolIndex) {
        if (toolCallback instanceof AsyncToolCallback) {
            AsyncToolCallback async = (AsyncToolCallback)toolCallback;
            return this.executeAsyncTool(async, request, toolContextMap, config, extraStateFromToolCall, cancellationTokens, toolIndex);
        }
        if (this.wrapSyncToolsAsAsync && !inParallelExecution) {
            Executor executor = this.getToolExecutor(config);
            AsyncToolCallback wrappedAsync = AsyncToolCallbackAdapter.wrapIfNeeded(toolCallback, executor, this.toolExecutionTimeout);
            return this.executeAsyncTool(wrappedAsync, request, toolContextMap, config, extraStateFromToolCall, cancellationTokens, toolIndex);
        }
        return this.executeSyncTool(toolCallback, request, toolContextMap, config);
    }

    private ToolCallResponse executeAsyncTool(AsyncToolCallback callback, ToolCallRequest request, Map<String, Object> toolContextMap, RunnableConfig config, Map<String, Object> extraStateFromToolCall) {
        return this.executeAsyncTool(callback, request, toolContextMap, config, extraStateFromToolCall, null, -1);
    }

    private ToolCallResponse executeAsyncTool(AsyncToolCallback callback, ToolCallRequest request, Map<String, Object> toolContextMap, RunnableConfig config, Map<String, Object> extraStateFromToolCall, Map<Integer, DefaultCancellationToken> cancellationTokens, int toolIndex) {
        ToolContext context = new ToolContext(toolContextMap);
        DefaultCancellationToken cancellationToken = null;
        try {
            CompletableFuture<String> future;
            if (callback instanceof CancellableAsyncToolCallback) {
                CancellableAsyncToolCallback cancellable = (CancellableAsyncToolCallback)callback;
                cancellationToken = new DefaultCancellationToken();
                if (cancellationTokens != null && toolIndex >= 0) {
                    cancellationTokens.put(toolIndex, cancellationToken);
                }
                future = cancellable.callAsync(request.getArguments(), context, cancellationToken);
            } else {
                future = callback.callAsync(request.getArguments(), context);
            }
            if (future == null) {
                return ToolCallResponse.error(request.getToolCallId(), request.getToolName(), "Async tool returned null future");
            }
            String result = future.orTimeout(callback.getTimeout().toMillis(), TimeUnit.MILLISECONDS).join();
            if (this.enableActingLog) {
                logger.info("[ThreadId {}] Agent {} acting, async tool {} finished", new Object[]{config.threadId().orElse("$default"), this.agentName, request.getToolName()});
                if (logger.isDebugEnabled()) {
                    logger.debug("Tool {} returned: {}", (Object)request.getToolName(), (Object)result);
                }
            }
            return ToolCallResponse.of(request.getToolCallId(), request.getToolName(), result);
        }
        catch (CompletionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof TimeoutException) {
                if (cancellationToken != null) {
                    cancellationToken.cancel();
                }
                extraStateFromToolCall.clear();
                logger.warn("Async tool {} timed out, discarding any state updates", (Object)request.getToolName());
                return ToolCallResponse.error(request.getToolCallId(), request.getToolName(), this.extractErrorMessage(cause));
            }
            if (cause instanceof ToolExecutionException) {
                ToolExecutionException toolExecutionException = (ToolExecutionException)cause;
                logger.error("Async tool {} execution failed, handling with processor: {}", new Object[]{request.getToolName(), this.toolExecutionExceptionProcessor.getClass().getName(), toolExecutionException});
                String result = this.toolExecutionExceptionProcessor.process(toolExecutionException);
                return ToolCallResponse.of(request.getToolCallId(), request.getToolName(), result);
            }
            logger.error("Async tool {} execution failed: {}", new Object[]{request.getToolName(), cause.getMessage(), cause});
            return ToolCallResponse.error(request.getToolCallId(), request.getToolName(), this.extractErrorMessage(cause));
        }
        catch (CancellationException e) {
            logger.warn("Async tool {} execution was cancelled", (Object)request.getToolName(), (Object)e);
            return ToolCallResponse.error(request.getToolCallId(), request.getToolName(), this.extractErrorMessage(e));
        }
        catch (Exception e) {
            logger.error("Async tool {} execution failed: {}", new Object[]{request.getToolName(), e.getMessage(), e});
            return ToolCallResponse.error(request.getToolCallId(), request.getToolName(), this.extractErrorMessage(e));
        }
    }

    private ToolCallResponse executeSyncTool(ToolCallback callback, ToolCallRequest request, Map<String, Object> toolContextMap, RunnableConfig config) {
        ToolContext context = new ToolContext(toolContextMap);
        try {
            String result = callback.call(request.getArguments(), context);
            if (this.enableActingLog) {
                logger.info("[ThreadId {}] Agent {} acting, tool {} finished", new Object[]{config.threadId().orElse("$default"), this.agentName, request.getToolName()});
                if (logger.isDebugEnabled()) {
                    logger.debug("Tool {} returned: {}", (Object)request.getToolName(), (Object)result);
                }
            }
            return ToolCallResponse.of(request.getToolCallId(), request.getToolName(), result);
        }
        catch (ToolExecutionException e) {
            logger.error("Tool {} execution failed, handling with processor: {}", new Object[]{request.getToolName(), this.toolExecutionExceptionProcessor.getClass().getName(), e});
            String result = this.toolExecutionExceptionProcessor.process(e);
            return ToolCallResponse.of(request.getToolCallId(), request.getToolName(), result);
        }
        catch (Exception e) {
            logger.error("Tool {} execution failed: {}", new Object[]{request.getToolName(), e.getMessage(), e});
            return ToolCallResponse.error(request.getToolCallId(), request.getToolName(), e);
        }
    }

    private String extractErrorMessage(Throwable error) {
        if (error == null) {
            return "Unknown error";
        }
        if (error instanceof TimeoutException) {
            return "Tool execution timed out";
        }
        if (error instanceof CancellationException) {
            return "Tool execution was cancelled";
        }
        if (error instanceof ToolCancelledException) {
            return "Tool execution was cancelled";
        }
        if (error instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return "Tool execution was interrupted";
        }
        return error.getMessage() != null ? error.getMessage() : error.getClass().getSimpleName();
    }

    private Executor getToolExecutor(RunnableConfig config) {
        return ParallelNode.getExecutor((RunnableConfig)config, (String)"_AGENT_TOOL_");
    }

    private ToolCallback resolve(String toolName, RunnableConfig config) {
        Optional<ToolCallback> fromNode;
        if (this.toolCallbacks != null && (fromNode = this.toolCallbacks.stream().filter(callback -> callback.getToolDefinition().name().equals(toolName)).findFirst()).isPresent()) {
            return fromNode.get();
        }
        ToolCallback fromDynamic = this.resolveFromConfigMetadata(toolName, config);
        if (fromDynamic != null) {
            return fromDynamic;
        }
        return this.toolCallbackResolver == null ? null : this.toolCallbackResolver.resolve(toolName);
    }

    private ToolCallback resolveFromConfigMetadata(String toolName, RunnableConfig config) {
        return Optional.ofNullable(config.context().get("_DYNAMIC_TOOL_CALLBACKS_")).filter(v -> v instanceof List).map(v -> (List)v).flatMap(list -> list.stream().filter(tc -> tc != null && toolName.equals(tc.getToolDefinition().name())).findFirst()).orElse(null);
    }

    public String getName() {
        return "_AGENT_TOOL_";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String agentName;
        private boolean enableActingLog;
        private boolean parallelToolExecution = false;
        private int maxParallelTools = 5;
        private Duration toolExecutionTimeout = Duration.ofMinutes(5L);
        private boolean wrapSyncToolsAsAsync = false;
        private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
        private Map<String, Object> toolContext = new HashMap<String, Object>();
        private ToolCallbackResolver toolCallbackResolver;
        private ToolExecutionExceptionProcessor toolExecutionExceptionProcessor;

        private Builder() {
        }

        public Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public Builder enableActingLog(boolean enableActingLog) {
            this.enableActingLog = enableActingLog;
            return this;
        }

        public Builder parallelToolExecution(boolean parallel) {
            this.parallelToolExecution = parallel;
            return this;
        }

        public Builder maxParallelTools(int max) {
            if (max < 1) {
                throw new IllegalArgumentException("maxParallelTools must be at least 1");
            }
            this.maxParallelTools = max;
            return this;
        }

        public Builder toolExecutionTimeout(Duration timeout) {
            this.toolExecutionTimeout = timeout;
            return this;
        }

        public Builder wrapSyncToolsAsAsync(boolean wrap) {
            this.wrapSyncToolsAsAsync = wrap;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.toolCallbacks = toolCallbacks;
            return this;
        }

        public Builder toolCallbackResolver(ToolCallbackResolver toolCallbackResolver) {
            this.toolCallbackResolver = toolCallbackResolver;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            this.toolContext = new HashMap<String, Object>(toolContext);
            return this;
        }

        public Builder toolExecutionExceptionProcessor(ToolExecutionExceptionProcessor toolExecutionExceptionProcessor) {
            if (toolExecutionExceptionProcessor == null) {
                toolExecutionExceptionProcessor = DefaultToolExecutionExceptionProcessor.builder().alwaysThrow(false).build();
            }
            this.toolExecutionExceptionProcessor = toolExecutionExceptionProcessor;
            return this;
        }

        public AgentToolNode build() {
            Objects.requireNonNull(this.toolExecutionTimeout, "toolExecutionTimeout must not be null");
            Objects.requireNonNull(this.toolExecutionExceptionProcessor, "toolExecutionExceptionProcessor must not be null");
            return new AgentToolNode(this);
        }
    }
}

