/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor.skills;

import com.alibaba.cloud.ai.graph.agent.interceptor.ModelCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelResponse;
import com.alibaba.cloud.ai.graph.skills.SkillPromptConstants;
import com.alibaba.cloud.ai.graph.skills.registry.SkillRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.prompt.SystemPromptTemplate;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.util.json.JsonParser;

public class SkillsInterceptor
extends ModelInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SkillsInterceptor.class);
    private final SkillRegistry skillRegistry;
    private final Map<String, List<ToolCallback>> groupedTools;

    private SkillsInterceptor(Builder builder) {
        if (builder.skillRegistry == null) {
            throw new IllegalArgumentException("SkillRegistry must be provided. Use SkillsAgentHook to load skills.");
        }
        this.skillRegistry = builder.skillRegistry;
        this.groupedTools = builder.groupedTools != null ? builder.groupedTools : Collections.emptyMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ModelResponse interceptModel(ModelRequest request, ModelCallHandler handler) {
        List skills = this.skillRegistry.listAll();
        if (skills.isEmpty()) {
            return handler.call(request);
        }
        Set<String> readSkillNames = this.extractReadSkillNames(request.getMessages());
        ArrayList<ToolCallback> skillTools = new ArrayList<ToolCallback>(request.getDynamicToolCallbacks());
        Map<String, List<ToolCallback>> grouped = this.getGroupedTools();
        for (String skillName : readSkillNames) {
            List<ToolCallback> toolsForSkill = grouped.get(skillName);
            if (toolsForSkill == null || toolsForSkill.isEmpty()) continue;
            skillTools.addAll(toolsForSkill);
            if (!logger.isInfoEnabled()) continue;
            logger.info("SkillsInterceptor: added {} tool(s) for skill '{}' to dynamicToolCallbacks", (Object)toolsForSkill.size(), (Object)skillName);
        }
        String skillsPrompt = SkillPromptConstants.buildSkillsPrompt((List)skills, (SkillRegistry)this.skillRegistry, (SystemPromptTemplate)this.skillRegistry.getSystemPromptTemplate());
        SystemMessage enhanced = this.enhanceSystemMessage(request.getSystemMessage(), skillsPrompt);
        if (logger.isDebugEnabled()) {
            logger.debug("Enhanced system message:\n{}", (Object)enhanced.getText());
        }
        ModelRequest modified = ModelRequest.builder(request).systemMessage(enhanced).dynamicToolCallbacks(skillTools).build();
        return handler.call(modified);
    }

    private Set<String> extractReadSkillNames(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Message message : messages) {
            AssistantMessage assistantMessage;
            if (!(message instanceof AssistantMessage) || !(assistantMessage = (AssistantMessage)message).hasToolCalls()) continue;
            for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
                String skillName;
                if (!"read_skill".equals(toolCall.name()) || (skillName = SkillsInterceptor.parseSkillNameFromArguments(toolCall.arguments())) == null || skillName.isEmpty()) continue;
                names.add(skillName);
            }
        }
        return names;
    }

    private static String parseSkillNameFromArguments(String arguments) {
        block4: {
            if (arguments == null || arguments.isBlank()) {
                return null;
            }
            try {
                Object parsed = JsonParser.fromJson((String)arguments, Map.class);
                if (parsed instanceof Map) {
                    Map map = (Map)parsed;
                    Object v = map.get("skill_name");
                    return v != null ? v.toString().trim() : null;
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Failed to parse read_skill arguments: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public Map<String, List<ToolCallback>> getGroupedTools() {
        if (this.groupedTools.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.groupedTools.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.copyOf((Collection)e.getValue())));
    }

    private SystemMessage enhanceSystemMessage(SystemMessage existing, String skillsSection) {
        if (existing == null) {
            return new SystemMessage(skillsSection);
        }
        return new SystemMessage(existing.getText() + "\n\n" + skillsSection);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public static class Builder {
        private SkillRegistry skillRegistry;
        private Map<String, List<ToolCallback>> groupedTools;

        public Builder skillRegistry(SkillRegistry skillRegistry) {
            this.skillRegistry = skillRegistry;
            return this;
        }

        public Builder groupedTools(Map<String, List<ToolCallback>> groupedTools) {
            this.groupedTools = groupedTools;
            return this;
        }

        public SkillsInterceptor build() {
            return new SkillsInterceptor(this);
        }
    }
}

