/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor.modelretry;

import com.alibaba.cloud.ai.graph.agent.interceptor.ModelCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelResponse;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;

public class ModelRetryInterceptor
extends ModelInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ModelRetryInterceptor.class);
    private final int maxAttempts;
    private final long initialDelay;
    private final long maxDelay;
    private final double backoffMultiplier;
    private final Predicate<Exception> retryableExceptionPredicate;

    private ModelRetryInterceptor(Builder builder) {
        this.maxAttempts = builder.maxAttempts;
        this.initialDelay = builder.initialDelay;
        this.maxDelay = builder.maxDelay;
        this.backoffMultiplier = builder.backoffMultiplier;
        this.retryableExceptionPredicate = builder.retryableExceptionPredicate;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModelResponse interceptModel(ModelRequest request, ModelCallHandler handler) {
        Exception lastException = null;
        long currentDelay = this.initialDelay;
        int attempt = 1;
        while (true) {
            if (attempt > this.maxAttempts) {
                throw new RuntimeException("Model call failed, maximum number of retries reached. " + this.maxAttempts, lastException);
            }
            try {
                block18: {
                    ModelResponse modelResponse;
                    block17: {
                        Message message;
                        if (attempt > 1) {
                            log.info("Retry model call, on the {}th attempt (out of {} attempts).", (Object)attempt, (Object)this.maxAttempts);
                        }
                        if ((message = (Message)(modelResponse = handler.call(request)).getMessage()) == null || message.getText() == null || !message.getText().startsWith("Exception:")) break block17;
                        String exceptionText = message.getText();
                        log.warn("The model call returned an exception message: {}", (Object)exceptionText);
                        if (attempt < this.maxAttempts && this.isRetryableExceptionMessage(exceptionText)) {
                            lastException = new RuntimeException(exceptionText);
                            if (currentDelay > 0L) {
                                try {
                                    log.info("Retry after {} ms", (Object)currentDelay);
                                    Thread.sleep(currentDelay);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    throw new RuntimeException("Retry interrupted", e);
                                }
                            }
                            break block18;
                        } else {
                            if (attempt >= this.maxAttempts) {
                                log.error("The maximum number of retries has been reached {}, and the model call has failed.", (Object)this.maxAttempts);
                                throw new RuntimeException("Model call failed, maximum number of retries reached:" + exceptionText);
                            }
                            return modelResponse;
                        }
                    }
                    if (attempt > 1) {
                        log.info("The model call succeeded after the {}th attempt.", (Object)attempt);
                    }
                    return modelResponse;
                }
                currentDelay = Math.min((long)((double)currentDelay * this.backoffMultiplier), this.maxDelay);
            }
            catch (Exception e) {
                lastException = e;
                log.warn("Model call failed (attempted {}/{}): {}", new Object[]{attempt, this.maxAttempts, e.getMessage()});
                if (attempt >= this.maxAttempts) {
                    log.error("The maximum number of retries has been reached {}, and the model call has failed.", (Object)this.maxAttempts);
                    throw new RuntimeException("Model call failed, maximum number of retries reached.", lastException);
                }
                if (!this.retryableExceptionPredicate.test(e)) {
                    log.warn("Exceptions cannot be retried and are thrown immediately: {}", (Object)e.getMessage());
                    throw new RuntimeException("Model call failed (non-retryable exception)", e);
                }
                if (currentDelay > 0L) {
                    try {
                        log.info("Retry after {} ms", (Object)currentDelay);
                        Thread.sleep(currentDelay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Retry interrupted", ie);
                    }
                }
                currentDelay = Math.min((long)((double)currentDelay * this.backoffMultiplier), this.maxDelay);
            }
            ++attempt;
        }
    }

    private boolean isRetryableExceptionMessage(String exceptionText) {
        String lowerText = exceptionText.toLowerCase();
        return lowerText.contains("i/o error") || lowerText.contains("remote host terminated") || lowerText.contains("connection") || lowerText.contains("timeout") || lowerText.contains("network") || lowerText.contains("handshake") || lowerText.contains("socket");
    }

    @Override
    public String getName() {
        return "ModelRetry";
    }

    public static class Builder {
        private int maxAttempts = 3;
        private long initialDelay = 1000L;
        private long maxDelay = 30000L;
        private double backoffMultiplier = 2.0;
        private Predicate<Exception> retryableExceptionPredicate = Builder::isRetryableException;

        public Builder maxAttempts(int maxAttempts) {
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("maxAttempts must be greater than or equal to 1");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder initialDelay(long initialDelay) {
            if (initialDelay < 0L) {
                throw new IllegalArgumentException("initialDelay must be greater than or equal to 0.");
            }
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder maxDelay(long maxDelay) {
            if (maxDelay < 0L) {
                throw new IllegalArgumentException("maxDelay must be greater than or equal to 0.");
            }
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder backoffMultiplier(double backoffMultiplier) {
            if (backoffMultiplier < 1.0) {
                throw new IllegalArgumentException("The backoffMultiplier must be >= 1.0");
            }
            this.backoffMultiplier = backoffMultiplier;
            return this;
        }

        public Builder retryableExceptionPredicate(Predicate<Exception> predicate) {
            this.retryableExceptionPredicate = predicate;
            return this;
        }

        public ModelRetryInterceptor build() {
            return new ModelRetryInterceptor(this);
        }

        private static boolean isRetryableException(Exception e) {
            String message = e.getMessage();
            if (message == null) {
                return false;
            }
            String lowerMessage = message.toLowerCase();
            if (lowerMessage.contains("i/o error") || lowerMessage.contains("remote host terminated") || lowerMessage.contains("connection") || lowerMessage.contains("timeout") || lowerMessage.contains("handshake") || lowerMessage.contains("socket")) {
                return true;
            }
            if (e.getClass().getName().contains("ResourceAccessException") || e.getClass().getName().contains("WebClientRequestException")) {
                return true;
            }
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                String causeClassName = cause.getClass().getName();
                if (!causeClassName.contains("IOException") && !causeClassName.contains("SocketException") && !causeClassName.contains("ConnectException") && !causeClassName.contains("TimeoutException") && !causeClassName.contains("SSLException")) continue;
                return true;
            }
            return false;
        }
    }
}

