/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;

public class ModelRequest {
    private final SystemMessage systemMessage;
    private final Map<String, Object> context;
    private final List<Message> messages;
    private final ToolCallingChatOptions options;
    private final List<String> tools;
    private final List<ToolCallback> dynamicToolCallbacks;
    private final Map<String, String> toolDescriptions;

    public ModelRequest(SystemMessage systemMessage, List<Message> messages, ToolCallingChatOptions options, List<String> tools, List<ToolCallback> dynamicToolCallbacks, Map<String, String> toolDescriptions, Map<String, Object> context) {
        this.systemMessage = systemMessage;
        this.messages = messages;
        this.options = options;
        this.tools = tools;
        this.dynamicToolCallbacks = dynamicToolCallbacks;
        this.toolDescriptions = toolDescriptions;
        this.context = context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModelRequest request) {
        return new Builder().systemMessage(request.systemMessage).messages(request.messages).options(request.options).tools(request.tools).dynamicToolCallbacks(request.dynamicToolCallbacks).toolDescriptions(request.toolDescriptions).context(request.context);
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public SystemMessage getSystemMessage() {
        return this.systemMessage;
    }

    public ToolCallingChatOptions getOptions() {
        return this.options;
    }

    public List<String> getTools() {
        return this.tools;
    }

    public List<ToolCallback> getDynamicToolCallbacks() {
        return this.dynamicToolCallbacks;
    }

    public Map<String, String> getToolDescriptions() {
        return this.toolDescriptions;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public static class Builder {
        private SystemMessage systemMessage;
        private List<Message> messages;
        private ToolCallingChatOptions options;
        private List<String> tools = List.of();
        private List<ToolCallback> dynamicToolCallbacks = List.of();
        private Map<String, String> toolDescriptions = new HashMap<String, String>();
        private Map<String, Object> context = new HashMap<String, Object>();

        public Builder systemMessage(SystemMessage systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public Builder options(ToolCallingChatOptions options) {
            this.options = options;
            return this;
        }

        public Builder tools(List<String> tools) {
            if (tools != null) {
                this.tools = new ArrayList<String>(tools);
            }
            return this;
        }

        public Builder dynamicToolCallbacks(List<ToolCallback> dynamicToolCallbacks) {
            if (dynamicToolCallbacks != null) {
                this.dynamicToolCallbacks = new ArrayList<ToolCallback>(dynamicToolCallbacks);
            }
            return this;
        }

        public Builder toolDescriptions(Map<String, String> toolDescriptions) {
            if (toolDescriptions != null) {
                this.toolDescriptions = new HashMap<String, String>(toolDescriptions);
            }
            return this;
        }

        public Builder context(Map<String, Object> context) {
            if (context != null) {
                this.context = new HashMap<String, Object>(context);
            }
            return this;
        }

        public ModelRequest build() {
            return new ModelRequest(this.systemMessage, this.messages, this.options, this.tools, this.dynamicToolCallbacks, this.toolDescriptions, this.context);
        }
    }
}

