/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.toolcalllimit;

public class ToolCallLimitExceededException
extends RuntimeException {
    private final int threadCount;
    private final int runCount;
    private final Integer threadLimit;
    private final Integer runLimit;
    private final String toolName;

    public ToolCallLimitExceededException(int threadCount, int runCount, Integer threadLimit, Integer runLimit, String toolName) {
        super(ToolCallLimitExceededException.buildMessage(threadCount, runCount, threadLimit, runLimit, toolName));
        this.threadCount = threadCount;
        this.runCount = runCount;
        this.threadLimit = threadLimit;
        this.runLimit = runLimit;
        this.toolName = toolName;
    }

    private static String buildMessage(int threadCount, int runCount, Integer threadLimit, Integer runLimit, String toolName) {
        Object toolDesc = toolName != null ? "'" + toolName + "' tool call" : "Tool call";
        StringBuilder sb = new StringBuilder((String)toolDesc + " limits exceeded: ");
        boolean first = true;
        if (threadLimit != null && threadCount >= threadLimit) {
            sb.append(String.format("thread limit (%d/%d)", threadCount, threadLimit));
            first = false;
        }
        if (runLimit != null && runCount >= runLimit) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(String.format("run limit (%d/%d)", runCount, runLimit));
        }
        return sb.toString();
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public Integer getThreadLimit() {
        return this.threadLimit;
    }

    public Integer getRunLimit() {
        return this.runLimit;
    }

    public String getToolName() {
        return this.toolName;
    }
}

