/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.skills;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.agent.hook.AgentHook;
import com.alibaba.cloud.ai.graph.agent.hook.HookPosition;
import com.alibaba.cloud.ai.graph.agent.hook.HookPositions;
import com.alibaba.cloud.ai.graph.agent.hook.skills.ReadSkillTool;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.skills.SkillsInterceptor;
import com.alibaba.cloud.ai.graph.skills.SkillMetadata;
import com.alibaba.cloud.ai.graph.skills.registry.SkillRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;

@HookPositions(value={HookPosition.BEFORE_AGENT})
public class SkillsAgentHook
extends AgentHook {
    private static final Logger logger = LoggerFactory.getLogger(SkillsAgentHook.class);
    private final SkillRegistry skillRegistry;
    private final boolean autoReload;
    private final Map<String, List<ToolCallback>> groupedTools;
    private final ToolCallback readSkillTool;

    private SkillsAgentHook(Builder builder) {
        if (builder.skillRegistry == null) {
            throw new IllegalArgumentException("SkillRegistry must be provided. Use FileSystemSkillRegistry.builder() to create one.");
        }
        this.skillRegistry = builder.skillRegistry;
        this.autoReload = builder.autoReload;
        this.groupedTools = builder.groupedTools != null ? builder.groupedTools : Collections.emptyMap();
        this.readSkillTool = ReadSkillTool.createReadSkillToolCallback(this.skillRegistry, "Reads the full content of a skill from the SkillRegistry.\nYou can use this tool to read the complete content of any skill by providing its name.\n\nUsage:\n- The skill_name parameter must match the name of the skill as registered in the registry\n- The tool returns the full content of the skill file (e.g., SKILL.md) without frontmatter\n- If the skill is not found, an error will be returned\n\nExample:\n- read_skill(\"pdf-extractor\")\n");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CompletableFuture<Map<String, Object>> beforeAgent(OverAllState state, RunnableConfig config) {
        if (this.autoReload) {
            try {
                this.skillRegistry.reload();
            }
            catch (UnsupportedOperationException e) {
                logger.debug("Reload not supported for registry type: {}", (Object)this.skillRegistry.getClass().getName());
            }
        }
        return CompletableFuture.completedFuture(Map.of());
    }

    public SkillRegistry getSkillRegistry() {
        return this.skillRegistry;
    }

    @Override
    public List<ModelInterceptor> getModelInterceptors() {
        SkillsInterceptor.Builder interceptorBuilder = SkillsInterceptor.builder().skillRegistry(this.skillRegistry);
        if (!this.groupedTools.isEmpty()) {
            interceptorBuilder.groupedTools(this.groupedTools);
        }
        return List.of(interceptorBuilder.build());
    }

    @Override
    public List<ToolCallback> getTools() {
        return List.of(this.readSkillTool);
    }

    public int getSkillCount() {
        return this.skillRegistry.size();
    }

    public boolean hasSkill(String skillName) {
        return this.skillRegistry.contains(skillName);
    }

    public List<SkillMetadata> listSkills() {
        return this.skillRegistry.listAll();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public static class Builder {
        private SkillRegistry skillRegistry;
        private boolean autoReload = false;
        private Map<String, List<ToolCallback>> groupedTools;

        public Builder skillRegistry(SkillRegistry skillRegistry) {
            this.skillRegistry = skillRegistry;
            return this;
        }

        public Builder autoReload(boolean autoReload) {
            this.autoReload = autoReload;
            return this;
        }

        public Builder groupedTools(Map<String, List<ToolCallback>> groupedTools) {
            this.groupedTools = groupedTools;
            return this;
        }

        public SkillsAgentHook build() {
            return new SkillsAgentHook(this);
        }
    }
}

