/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.skills;

import com.alibaba.cloud.ai.graph.skills.registry.SkillRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.IOException;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class ReadSkillTool
implements BiFunction<ReadSkillRequest, ToolContext, String> {
    public static final String READ_SKILL = "read_skill";
    public static final String DESCRIPTION = "Reads the full content of a skill from the SkillRegistry.\nYou can use this tool to read the complete content of any skill by providing its name.\n\nUsage:\n- The skill_name parameter must match the name of the skill as registered in the registry\n- The tool returns the full content of the skill file (e.g., SKILL.md) without frontmatter\n- If the skill is not found, an error will be returned\n\nExample:\n- read_skill(\"pdf-extractor\")\n";
    private static final Logger logger = LoggerFactory.getLogger(ReadSkillTool.class);
    private final SkillRegistry skillRegistry;

    public ReadSkillTool(SkillRegistry skillRegistry) {
        if (skillRegistry == null) {
            throw new IllegalArgumentException("SkillRegistry cannot be null");
        }
        this.skillRegistry = skillRegistry;
    }

    public static ToolCallback createReadSkillToolCallback(SkillRegistry skillRegistry, String description) {
        return FunctionToolCallback.builder((String)READ_SKILL, (BiFunction)new ReadSkillTool(skillRegistry)).description(description != null ? description : DESCRIPTION).inputType(ReadSkillRequest.class).build();
    }

    @Override
    public String apply(ReadSkillRequest request, ToolContext toolContext) {
        try {
            if (request.skillName == null || request.skillName.isEmpty()) {
                return "Error: skill_name is required";
            }
            String content = this.skillRegistry.readSkillContent(request.skillName);
            return content;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid request for read_skill: {}", (Object)e.getMessage());
            return "Error: " + e.getMessage();
        }
        catch (IllegalStateException e) {
            logger.warn("Skill not found: {}", (Object)e.getMessage());
            return "Error: " + e.getMessage();
        }
        catch (IOException e) {
            logger.error("Error reading skill content: {}", (Object)e.getMessage(), (Object)e);
            return "Error reading skill file: " + e.getMessage();
        }
        catch (Exception e) {
            logger.error("Unexpected error reading skill: {}", (Object)e.getMessage(), (Object)e);
            return "Error: " + e.getMessage();
        }
    }

    public static class ReadSkillRequest {
        @JsonProperty(required=true, value="skill_name")
        @JsonPropertyDescription(value="The name of the skill to read, must match one of the names in the Available Skills list")
        public String skillName;

        public ReadSkillRequest() {
        }

        public ReadSkillRequest(String skillName) {
            this.skillName = skillName;
        }
    }
}

