/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.shelltool;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.agent.hook.AgentHook;
import com.alibaba.cloud.ai.graph.agent.hook.HookPosition;
import com.alibaba.cloud.ai.graph.agent.hook.HookPositions;
import com.alibaba.cloud.ai.graph.agent.hook.ToolInjection;
import com.alibaba.cloud.ai.graph.agent.tools.ShellSessionManager;
import com.alibaba.cloud.ai.graph.agent.tools.ShellTool2;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.support.ToolCallbacks;
import org.springframework.ai.tool.ToolCallback;

@HookPositions(value={HookPosition.BEFORE_AGENT, HookPosition.AFTER_AGENT})
public class ShellToolAgentHook
extends AgentHook
implements ToolInjection {
    private static final Logger log = LoggerFactory.getLogger(ShellToolAgentHook.class);
    private ShellTool2 shellTool2;
    private String shellToolName;

    private ShellToolAgentHook() {
    }

    private ShellToolAgentHook(ShellTool2 shellTool2, String shellToolName) {
        this.shellTool2 = shellTool2;
        this.shellToolName = shellToolName;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CompletableFuture<Map<String, Object>> beforeAgent(OverAllState state, RunnableConfig config) {
        ShellSessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            log.warn("ShellToolAgentHook: No ShellTool2 injected, skipping initialization");
            return CompletableFuture.completedFuture(new HashMap());
        }
        log.info("ShellToolAgentHook: Initializing shell session before agent execution");
        try {
            sessionManager.initialize(config);
            log.info("Shell session initialized successfully");
        }
        catch (Exception e) {
            log.error("Failed to initialize shell session", (Throwable)e);
            throw new RuntimeException("Failed to initialize shell session", e);
        }
        return CompletableFuture.completedFuture(new HashMap());
    }

    @Override
    public CompletableFuture<Map<String, Object>> afterAgent(OverAllState state, RunnableConfig config) {
        ShellSessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            log.warn("ShellToolAgentHook: No ShellTool2 injected, skipping cleanup");
            return CompletableFuture.completedFuture(new HashMap());
        }
        log.info("ShellToolAgentHook: Cleaning up shell session after agent execution");
        try {
            sessionManager.cleanup(config);
            log.info("Shell session cleaned up successfully");
        }
        catch (Exception e) {
            log.error("Failed to cleanup shell session", (Throwable)e);
        }
        return CompletableFuture.completedFuture(new HashMap());
    }

    @Override
    public String getName() {
        return "ShellToolAgentHook";
    }

    @Override
    public void injectTool(ToolCallback toolCallback) {
        if (this.shellTool2 != null) {
            return;
        }
        log.info("ShellToolAgentHook: Processing tool callback for shell tool extraction");
        try {
            ShellTool2 extractedShellTool2 = this.extractShellTool2(toolCallback);
            if (extractedShellTool2 != null) {
                this.shellTool2 = extractedShellTool2;
                log.info("Successfully extracted and injected ShellTool2 from tool: {}", (Object)toolCallback.getToolDefinition().name());
                return;
            }
            log.warn("Failed to extract ShellTool2 from tool: {}", (Object)toolCallback.getToolDefinition().name());
        }
        catch (Exception e) {
            log.error("Error extracting ShellTool2 from tool callback", (Throwable)e);
        }
    }

    private ShellTool2 extractShellTool2(ToolCallback toolCallback) {
        try {
            for (Class<?> clazz = toolCallback.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Field toolObjectField = clazz.getDeclaredField("toolObject");
                    toolObjectField.setAccessible(true);
                    Object toolObject = toolObjectField.get(toolCallback);
                    if (toolObject instanceof ShellTool2) {
                        return (ShellTool2)toolObject;
                    }
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            log.debug("Could not extract ShellTool2 from ToolCallback via reflection", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<ToolCallback> getTools() {
        if (this.shellTool2 == null) {
            log.info("No ShellTool2 instance injected, creating default instance");
            this.shellTool2 = ShellTool2.builder(System.getProperty("user.dir")).build();
        }
        return Arrays.asList(ToolCallbacks.from((Object[])new Object[]{this.shellTool2}));
    }

    @Override
    public String getRequiredToolName() {
        return this.shellToolName;
    }

    @Override
    public Class<? extends ToolCallback> getRequiredToolType() {
        return null;
    }

    protected ShellTool2 getShellTool2() {
        return this.shellTool2;
    }

    private ShellSessionManager getSessionManager() {
        if (this.shellTool2 != null) {
            return this.shellTool2.getSessionManager();
        }
        return null;
    }

    public static class Builder {
        private ShellTool2 shellTool2;
        private String shellToolName;

        public Builder shellTool2(ShellTool2 shellTool2) {
            this.shellTool2 = shellTool2;
            return this;
        }

        public Builder shellToolName(String shellToolName) {
            this.shellToolName = shellToolName;
            return this;
        }

        public ShellToolAgentHook build() {
            return new ShellToolAgentHook(this.shellTool2, this.shellToolName);
        }
    }
}

