/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.messages;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.action.AsyncNodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.agent.hook.messages.AgentCommand;
import com.alibaba.cloud.ai.graph.agent.hook.messages.UpdatePolicy;
import com.alibaba.cloud.ai.graph.state.ReplaceAllWith;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.ai.chat.messages.Message;

public abstract class MessagesModelHook
implements Hook {
    private String agentName;
    private ReactAgent agent;

    public AgentCommand beforeModel(List<Message> previousMessages, RunnableConfig config) {
        return new AgentCommand(previousMessages);
    }

    public AgentCommand afterModel(List<Message> previousMessages, RunnableConfig config) {
        return new AgentCommand(previousMessages);
    }

    @Override
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public ReactAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setAgent(ReactAgent agent) {
        this.agent = agent;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    public static BeforeModelAction beforeModelAction(MessagesModelHook hook) {
        return new BeforeModelAction(hook);
    }

    public static AfterModelAction afterModelAction(MessagesModelHook hook) {
        return new AfterModelAction(hook);
    }

    public static class BeforeModelAction
    implements AsyncNodeActionWithConfig {
        private final MessagesModelHook messagesModelHook;

        public BeforeModelAction(MessagesModelHook messagesModelHook) {
            this.messagesModelHook = messagesModelHook;
        }

        public CompletableFuture<Map<String, Object>> apply(OverAllState state, RunnableConfig config) {
            List<Message> messages = state.value("messages").orElse(List.of());
            AgentCommand command = this.messagesModelHook.beforeModel(messages, config);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (command.getMessages() != null) {
                if (UpdatePolicy.REPLACE == command.getUpdatePolicy()) {
                    result.put("messages", ReplaceAllWith.of(command.getMessages()));
                } else {
                    result.put("messages", command.getMessages());
                }
            }
            if (command.getJumpTo() != null) {
                result.put("jump_to", command.getJumpTo().name());
            }
            return CompletableFuture.completedFuture(result);
        }
    }

    public static class AfterModelAction
    implements AsyncNodeActionWithConfig {
        private final MessagesModelHook messagesModelHook;

        public AfterModelAction(MessagesModelHook messagesModelHook) {
            this.messagesModelHook = messagesModelHook;
        }

        public CompletableFuture<Map<String, Object>> apply(OverAllState state, RunnableConfig config) {
            List<Message> messages = state.value("messages").orElse(List.of());
            AgentCommand command = this.messagesModelHook.afterModel(messages, config);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (command.getMessages() != null) {
                if (UpdatePolicy.REPLACE == command.getUpdatePolicy()) {
                    result.put("messages", ReplaceAllWith.of(command.getMessages()));
                } else {
                    result.put("messages", command.getMessages());
                }
            }
            if (command.getJumpTo() != null) {
                result.put("jump_to", command.getJumpTo().name());
            }
            return CompletableFuture.completedFuture(result);
        }
    }
}

